% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wbyscrku.R
\name{wbyscrku}
\alias{wbyscrku}
\title{Bayesian univariate estimates for competing risk gene expression data using AFT model.}
\usage{
wbyscrku(m, n, STime, Event, nc, ni, data)
}
\arguments{
\item{m}{Starting column number of covariates of study from high dimensional entered data.}

\item{n}{Ending column number of covariates of study from high dimensional entered data.}

\item{STime}{name of survival time in data.}

\item{Event}{name of event status in data. 0 is for censored and 1 for occurrence of event of interest and 2 for occurrence of event due to other causes.}

\item{nc}{number of markov chain.}

\item{ni}{number of iteration for MCMC.}

\item{data}{High dimensional gene expression data that contains event status with competing risk, survival time and and set of covariates.}
}
\value{
posterior estimates (Coef, SD, Credible Interval) of regression coefficient of covariate(which is/are chosen as columns in data) in model and deviance are there. Outcome shows together for all covariates chosen from column m to n.
}
\description{
Provides univariate estimate of AFT model using MCMC for competing risk high dimensional gene expression data. It also dea with missing values.
}
\details{
Here AFT model has been used with weibull distribution.
This function deals covariates (in data) with missing values. Missing value in any column(covariate) is replaced by mean of that particular covariate.
}
\examples{
##
data(hdata)
#1<=p<=q<=nrow(data)
wbyscrku(9,13,STime="os",Event="death2",2,100,hdata)
##
}
\references{
Prabhash et al(2016) <doi:10.21307/stattrans-2016-046>
}
\seealso{
wbysuni, wbyscrkm
}
\author{
Atanu Bhattacharjee, Gajendra Kumar Vishwakarma and Pragya Kumari
}
