% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grids.R
\name{raster_io}
\alias{raster_io}
\alias{raster_io0}
\title{GDAL RasterIO parameter creator}
\usage{
raster_io0(
  src_offset,
  src_dim,
  out_dim = src_dim,
  resample = "NearestNeighbour"
)
}
\arguments{
\item{src_offset}{index offset (0-based, top left)}

\item{src_dim}{source dimension (XY)}

\item{out_dim}{output dimension (XY, optional src_dim will be used if not set)}

\item{resample}{resampling algorith for GDAL see details}
}
\value{
numeric vector of values specifying offset, source dimension, output dimension
}
\description{
Basic function to create the window paramers as used by GDAL RasterIO.
}
\details{
Resampling algorithm is one of 'NearestNeighbour' (default), 'Average', 'Bilinear', 'Cubic', 'CubicSpline', 'Gauss', 'Lanczos', 'Mode', but
more may be available given the version of GDAL in use.
}
\examples{
raster_io0(c(0L, 0L), src_dim = c(24L, 10L))
}
