% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjacencies.R
\name{adjacencies}
\alias{adjacencies}
\alias{bl}
\alias{tl}
\alias{br}
\alias{tr}
\alias{image0}
\alias{image1}
\alias{text0}
\title{Adjacency, for use in creating area based meshes}
\usage{
bl(x)

tl(x)

br(x)

tr(x)

image0(x, ...)

image1(x, ...)

text0(x, ...)
}
\arguments{
\item{x}{matrix}

\item{...}{arguments passed to image()}
}
\value{
matrix, padded by one row and one column relative to input
}
\description{
Functions 'bottom left', 'top left', 'bottom right', and 'top right' named by
their initials, provide very low level relative positional structures for use in
raster logic. These are used to traverse the divide left by area-based rasters which are
inherently a discrete value across a finite element. If we want that element as part of a
continuous surface we need to find local relative values for its corners. Used in
quadmesh and anglr packages, and useful for calculating neighbourhood values.
}
\details{
Some tiny functions 'image0', 'image1', 'text0' exist purely to illustrate the ideas in
a vignette.
}
\examples{
(m <- matrix(1:12, 3))
tl(m)
tr(m)
bl(m)
br(m)
tl(br(m))
image0(tl(br(m)))
text0(tl(br(m)))
}
