% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ghg_flux.R
\name{calculate_regression}
\alias{calculate_regression}
\title{calculate_regression}
\usage{
calculate_regression(
  data,
  ghg,
  reference_time,
  duration_minutes = 7,
  num_rows = 300
)
}
\arguments{
\item{data}{Data from the LI-COR Trace Gas Analyzer that has been processed and time-converted.}

\item{ghg}{Column name of the file containing data on GHG concentration (e.g., "CH4", "N2O").}

\item{reference_time}{The date and time at which the measurement started.}

\item{duration_minutes}{The duration  of the measurement, default to 7.}

\item{num_rows}{The number of rows used to perform the regression, default to 300.}
}
\value{
A tibble containing the time range (POSIXct format) of the slope and R2 (both numeric) from the simple linear regression.
}
\description{
Calculate the slope of greenhouse gas (GHG) concentration change over time using simple linear regression.
}
\examples{
data(n2o)
calculate_regression(n2o, "N2O", as.POSIXct("2023-05-04 09:16:15", tz = "UTC"))
}
