% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/targeting_idea_service.R
\name{TargetingIdeaService_selector}
\alias{TargetingIdeaService_selector}
\title{TargetingIdeaService - Selector}
\usage{
TargetingIdeaService_selector(categoryProductsAndServices, competition,
  ideaTextFilter_included, ideaTextFilter_excluded, includeAdultContent,
  language, location, network_GoogleSearch, network_SearchNetwork,
  relatedToQuery, relatedToUrl, searchVolumeMinimum, searchVolumeMaximum,
  seedAdGroupId, requestType, attributeTypes, pagingStartIndex,
  pagingNumberResults, apiVersion)
}
\arguments{
\item{categoryProductsAndServices}{A keyword category ID (Integer) in the "Products and Services" taxonomy that all search results should belong to.}

\item{competition}{Vector of Levels of competition that should be included in the results}

\item{ideaTextFilter_included}{The vector of strings that should be included}

\item{ideaTextFilter_excluded}{The vector of strings that should be excluded}

\item{includeAdultContent}{TRUE or FALSE option for including the targeting of Adult Content.}

\item{language}{The Language (or Criterion ID) that all results should be targeted against.}

\item{location}{The Location (or Criterion ID) that all results should be targeted against.}

\item{network_GoogleSearch}{Whether search should be targeting Google Search}

\item{network_SearchNetwork}{Whether search should be targeting the Google Search Network (AFS)}

\item{relatedToQuery}{The vector of queries to post to the API as a Search Parameter.}

\item{relatedToUrl}{The vector of URLs to post to the API, which results will be related to.}

\item{searchVolumeMinimum}{The minimum Search Volume that should be targeted.}

\item{searchVolumeMaximum}{The maximum Search Volume that should be targeted.}

\item{seedAdGroupId}{The Adgroup ID that should be used as a seed for generating new ideas.}

\item{requestType}{Represents the type of the request.}

\item{attributeTypes}{Vector of Attributes Types.}

\item{pagingStartIndex}{Index of the first result to return. (Optional)}

\item{pagingNumberResults}{Maximum number of results to return. This figure is limited to 700. (Optional)}

\item{apiVersion}{Version of the API for the request}
}
\value{
Returns the XML text for Targeting Idea Service Selector
}
\description{
TargetingIdeaService.TargetingIdeaSelector
}
\details{
The main descriptor for choosing specified criteria.
}
\references{
Documentation content adapted from \href{https://developers.google.com/adwords/api/docs/reference/v201802/TargetingIdeaService.TargetingIdeaSelector}{Google Adwords API documentation} under license from \href{https://creativecommons.org/licenses/by/3.0/}{CC BY 3.0}
}
