% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/work_test_norm_global.R
\name{exp_sample_size_norm_global}
\alias{exp_sample_size_norm_global}
\title{Calculate expected sample size for a globally efficient adaptive design when working design is followed until the final interim analysis time and the final analysis time is fixed.}
\usage{
exp_sample_size_norm_global(
  initial_test = 0,
  effect_size = 0,
  time = 0,
  final_time = 0,
  input_check = TRUE
)
}
\arguments{
\item{initial_test}{Designate the initial working test generated by \code{\link{work_test_norm_global}} function.}

\item{effect_size}{The effect size, on the basis of which the power or sample size calculation will be performed. In globally efficient designs, any real value is allowed.}

\item{time}{The time of the current analysis.}

\item{final_time}{The time of the final analysis.}

\item{input_check}{Indicate whether or not the arguments input by user contain invalid values.}
}
\value{
It returns the expected sample size when 'effect size' is the truth.
}
\description{
\code{sample_size_norm_global} calculates the power if the time of the final
analysis is given and otherwise the sample size.
The computed power for \code{effect_size} is an approximate lower bound.
Sample size is also calculated on the basis of the bound.
}
\seealso{
\code{\link{adaptive_analysis_norm_global}} for example of this function.
}
