% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoStageDesign.R
\name{simulate,TwoStageDesign,numeric-method}
\alias{simulate,TwoStageDesign,numeric-method}
\title{Draw samples from a two-stage design}
\usage{
\S4method{simulate}{TwoStageDesign,numeric}(object, nsim, dist, theta, seed = NULL, ...)
}
\arguments{
\item{object}{\code{TwoStageDesign} to draw samples from}

\item{nsim}{number of simulation runs}

\item{dist}{data distribution}

\item{theta}{location parameter of the data distribution}

\item{seed}{random seed}

\item{...}{further optional arguments}
}
\value{
\code{simulate()} returns a \code{data.frame} with \code{nsim}
rows and for each row (each simulation run) the following columns
\itemize{
\item theta: The effect size
\item n1: First-stage sample size
\item c1f: Stopping for futility boundary
\item c1e: Stopping for efficacy boundary
\item x1: First-stage outcome
\item n2: Resulting second-stage sample size after observing x1
\item c2: Resulting second-stage decision-boundary after observing x1
\item x2: Second-stage outcome
\item reject: Decision whether the null hypothesis is rejected or not
}
}
\description{
\code{simulate} allows to draw samples from a given
\code{\link{TwoStageDesign}}.
}
\examples{
design <- TwoStageDesign(25, 0, 2, 25, 2, order = 5)
# draw samples assuming two-armed design
simulate(design, 10, Normal(), .3, 42)

}
\seealso{
\code{\link{TwoStageDesign}}
}
