% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adoptr.R
\docType{package}
\name{adoptr}
\alias{adoptr-package}
\alias{adoptr}
\title{Adaptive Optimal Two-Stage Designs}
\description{
The \pkg{adoptr} package provides functionality to explore custom optimal
two-stage designs for one- or two-arm superiority tests.
For more details on the theoretical background see
\url{doi:10.1002/sim.8291} and \url{doi:10.18637/jss.v098.i09}.
\pkg{adoptr} makes heavy use of the S4 class system.
A good place to start learning about it can be found
\href{http://adv-r.had.co.nz/OO-essentials.html}{here}.
}
\section{Quickstart}{


For a sample workflow and a quick demo of the capabilities, see
\href{https://optad.github.io/adoptr/articles/adoptr.html}{here}.

A more detailed description of the background and the usage of \pkg{adoptr}
can be found \href{https://optad.github.io/adoptr/articles/adoptr_jss.html}{here}
or here \url{doi:10.18637/jss.v098.i09} .

A variety of examples is presented in the validation report hosted
\href{https://optad.github.io/adoptr-validation-report/}{here}.
}

\section{Designs}{


\pkg{adoptr} currently supports \code{\link{TwoStageDesign}},
\code{\link{GroupSequentialDesign}}, and \code{\link{OneStageDesign}}.
}

\section{Data distributions}{


The implemented data distributions are \code{\link{Normal}}, \code{\link{Binomial}},
\code{\link{Student}}, \code{\link{Survival}}, \code{\link{ChiSquared}} (including
\code{\link{Pearson2xK}} and \code{\link{ZSquared}}) and \code{\link{ANOVA}}.
}

\section{Priors}{


Both \code{\link{ContinuousPrior}} and \code{\link{PointMassPrior}} are
supported for the single parameter of a \code{\link{DataDistribution}}.
}

\section{Scores}{


See \code{\link{Scores}} for information on the basic system of representing
scores.
Available scores are \code{\link{ConditionalPower}},
\code{\link{ConditionalSampleSize}}, \code{\link{Power}}, and
\code{\link{ExpectedSampleSize}}.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/optad/adoptr}
  \item \url{https://optad.github.io/adoptr/}
  \item Report bugs at \url{https://github.com/optad/adoptr/issues}
}

}
\author{
\strong{Maintainer}: Maximilian Pilz \email{maximilian.pilz@itwm.fraunhofer.de} (\href{https://orcid.org/0000-0002-9685-1613}{ORCID})

Authors:
\itemize{
  \item Kevin Kunzmann \email{kevin.kunzmann@boehringer-ingelheim.com} (\href{https://orcid.org/0000-0002-1140-7143}{ORCID}) [copyright holder]
  \item Jan Meis \email{meis@imbi.uni-heidelberg.de} (\href{https://orcid.org/0000-0001-5407-7220}{ORCID})
  \item Nico Bruder \email{bruder@imbi.uni-heidelberg.de} (\href{https://orcid.org/0009-0004-9522-2075}{ORCID})
}

}
