% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChiSquaredDistribution.R
\docType{class}
\name{ChiSquared-class}
\alias{ChiSquared-class}
\alias{ChiSquared}
\alias{quantile,ChiSquared-method}
\alias{simulate,ChiSquared,numeric-method}
\title{Chi-Squared data distribution}
\usage{
ChiSquared(df)

\S4method{quantile}{ChiSquared}(x, probs, n, theta, ...)

\S4method{simulate}{ChiSquared,numeric}(object, nsim, n, theta, seed = NULL, ...)
}
\arguments{
\item{df}{number of degrees of freedom}

\item{x}{outcome}

\item{probs}{vector of probabilities}

\item{n}{sample size}

\item{theta}{distribution parameter}

\item{...}{further optional arguments}

\item{object}{object of class \code{ChiSquared}}

\item{nsim}{number of simulation runs}

\item{seed}{random seed}
}
\description{
Implements a chi-squared distribution. The classes \code{Pearson2xk}
and \code{ZSquared} are subclasses, used in two different situations.
\code{Pearson2xK} is used when testing k groups for homogeneity in
response rates. The null hypothesis is
\ifelse{html}{\out{r<sub>1</sub>}=...=\out{r<sub>k</sub>}}{\eqn{r_1=...=r_k}}, and the
alternative is that there exists a pair of groups with differing rates.
\code{ZSquared} implements the square of a normally distributed random variable
with mean \eqn{\mu} and standard deviation \eqn{\sigma^2}.
}
\examples{
datadist <- ChiSquared(df=4)

}
\seealso{
see \code{\link{probability_density_function}} and
\code{\link{cumulative_distribution_function}} to evaluate the pdf
and the cdf, respectively.
}
