% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_expected_records.R
\name{derive_expected_records}
\alias{derive_expected_records}
\title{Derive Expected Records}
\usage{
derive_expected_records(
  dataset,
  dataset_ref,
  by_vars = NULL,
  set_values_to = NULL
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{dataset_ref} and \code{by_vars} arguments are expected to be in the dataset.

\describe{
\item{Default value}{none}
}}

\item{dataset_ref}{Expected observations dataset

Data frame with the expected observations, e.g., all the expected
combinations of \code{PARAMCD}, \code{PARAM}, \code{AVISIT}, \code{AVISITN}, ...

\describe{
\item{Default value}{none}
}}

\item{by_vars}{Grouping variables

For each group defined by \code{by_vars} those observations from \code{dataset_ref}
are added to the output dataset which do not have a corresponding observation
in the input dataset.

\describe{
\item{Default value}{\code{NULL}}
}}

\item{set_values_to}{Variables to be set

The specified variables are set to the specified values for the new
observations.

A list of variable name-value pairs is expected.
\itemize{
\item LHS refers to a variable.
\item RHS refers to the values to set to the variable. This can be a string, a
symbol, a numeric value, \code{NA}, or expressions, e.g., \code{exprs(PARAMCD =   "TDOSE", PARCAT1 = "OVERALL")}.
}

\describe{
\item{Default value}{\code{NULL}}
}}
}
\value{
The input dataset with the missed expected observations added for each
\code{by_vars}. Note, a variable will only be populated in the new parameter rows
if it is specified in \code{by_vars} or \code{set_values_to}.
}
\description{
Add expected records as new observations for each 'by group' when the dataset
contains missing observations.
}
\details{
For each group (the variables specified in the \code{by_vars} parameter),
those records from \code{dataset_ref} that are missing in the input
dataset are added to the output dataset.
}
\examples{
library(tibble)

adqs <- tribble(
  ~USUBJID, ~PARAMCD, ~AVISITN, ~AVISIT, ~AVAL,
  "1",      "a",             1, "WEEK 1",   10,
  "1",      "b",             1, "WEEK 1",   11,
  "2",      "a",             2, "WEEK 2",   12,
  "2",      "b",             2, "WEEK 2",   14
)

# Example 1. visit variables are parameter independent
parm_visit_ref <- tribble(
  ~AVISITN, ~AVISIT,
  1,        "WEEK 1",
  2,        "WEEK 2"
)

derive_expected_records(
  dataset = adqs,
  dataset_ref = parm_visit_ref,
  by_vars = exprs(USUBJID, PARAMCD),
  set_values_to = exprs(DTYPE = "DERIVED")
)

# Example 2. visit variables are parameter dependent
parm_visit_ref <- tribble(
  ~PARAMCD, ~AVISITN, ~AVISIT,
  "a",             1, "WEEK 1",
  "a",             2, "WEEK 2",
  "b",             1, "WEEK 1"
)

derive_expected_records(
  dataset = adqs,
  dataset_ref = parm_visit_ref,
  by_vars = exprs(USUBJID, PARAMCD),
  set_values_to = exprs(DTYPE = "DERIVED")
)

}
\seealso{
BDS-Findings Functions for adding Parameters/Records: 
\code{\link{default_qtc_paramcd}()},
\code{\link{derive_extreme_event}()},
\code{\link{derive_extreme_records}()},
\code{\link{derive_locf_records}()},
\code{\link{derive_param_bmi}()},
\code{\link{derive_param_bsa}()},
\code{\link{derive_param_computed}()},
\code{\link{derive_param_doseint}()},
\code{\link{derive_param_exist_flag}()},
\code{\link{derive_param_exposure}()},
\code{\link{derive_param_framingham}()},
\code{\link{derive_param_map}()},
\code{\link{derive_param_qtc}()},
\code{\link{derive_param_rr}()},
\code{\link{derive_param_wbc_abs}()},
\code{\link{derive_summary_records}()}
}
\concept{der_prm_bds_findings}
\keyword{der_prm_bds_findings}
