% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot,EstimatorScoreResultList-method}
\alias{plot,EstimatorScoreResultList-method}
\title{Plot performance scores for point and interval estimators}
\usage{
\S4method{plot}{EstimatorScoreResultList}(x, y, ...)
}
\arguments{
\item{x}{an output object from evaluate_estimator (\code{EstimatorScoreResult}) or a list
of such objects (\code{EstimatorScoreResultList}).}

\item{y}{unused.}

\item{...}{additional arguments handed down to ggplot.}
}
\value{
a \code{\link[ggplot2]{ggplot}} object visualizing the score values.
}
\description{
This function extract the values of mu and the score values and a facet plot with
one facet per score. If the input argument is a list, the different estimators
will be displayed in the same facets, differentiated by color.
}
\examples{
score_result1 <- evaluate_estimator(
  MSE(),
  estimator = SampleMean(),
  data_distribution = Normal(FALSE),
  design = get_example_design(),
  mu=seq(-.75, 1.32, 0.03),
  sigma=1)
# Plotting the result of evaluate_estimator
plot(score_result1)

score_result2 <- evaluate_estimator(
  MSE(),
  estimator = AdaptivelyWeightedSampleMean(w1 = 0.8),
  data_distribution = Normal(FALSE),
  design = get_example_design(),
  mu=seq(-.75, 1.32, 0.03),
  sigma=1)
# Plotting a list of different score results
plot(c(score_result1, score_result2))
}
