% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators.R
\docType{class}
\name{Statistic-class}
\alias{Statistic-class}
\alias{Statistic}
\alias{Statistics}
\alias{Estimator}
\title{Statistics and Estimators of the adestr package}
\arguments{
\item{label}{name of the statistic. Used in printing methods.}
}
\value{
An object of class \code{Statistic}. This class signals that
an object can be supplied to the \code{\link{analyze}} function.
}
\description{
The \code{\link{Statistic}} class is a parent class for the classes
\code{\link{Estimator}} and \code{\link{PValue}}. The \code{\link{Estimator}} class is a parent
for the classes \code{\link{PointEstimator}} and \code{\link{ConfidenceInterval}}.
}
\details{
The function \code{\link{analyze}} can be used to calculate the value
of a \code{\link{Statistic}} for a given dataset.

The function \code{\link{evaluate_estimator}} can be used to evaluate
\link[adestr:EstimatorScore]{distributional quantities} of an \code{\link{Estimator}}
like the \code{\link{MSE}} for a \code{\link{PointEstimator}} or the
\code{\link{Coverage}} for a \code{\link{ConfidenceInterval}}.
}
\seealso{
\code{\link{PointEstimator}} \code{\link{ConfidenceInterval}} \code{\link{PValue}}

\code{\link{analyze}} \code{\link{evaluate_estimator}}

\code{\link{EstimatorScore}}
}
