% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred.ah.R
\name{predict.ah}
\alias{predict.ah}
\title{Prediction Based on the Fitted Additive Hazards Model}
\usage{
\method{predict}{ah}(object, newdata, newtime, ...)
}
\arguments{
\item{object}{an object of class inhering from \code{\link{ah}}.}

\item{newdata}{a dataframe of an individual's predictors.}

\item{newtime}{a given sequence of time points at which the prediction is performed.
The time should be on the same scale as the survival time in \code{\link[survival]{Surv}}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A dataframe including the time points for prediction, predicted values and their standard errors.
}
\description{
This function predicts a subject's overall hazard rates at given time points
based on this subject's covariate values.  The prediction function is an additive
hazards model fitted using \code{\link{ah}}.
}
\examples{
library(survival)
###  fit the additive hazards model to the data
nwts<- nwtsco[1:100,]
fit <- ah(Surv(trel,relaps) ~ age + instit, data = nwts,  ties = FALSE, robust = FALSE)

###  see the covariate names in the prediction function
fit$call
###  the newdata should be a dataframe
###  the variable names are the same as the covariate names in
###  the prediction function
newdata <- data.frame(age=60, instit =1)

###  an alternative way to give the newdata
newdata <- nwtsco[101,]

###  based on this subject's covariate values, the function predicts  individual specific
###  hazard rates at time points 3 and 5
predict(fit, newdata, newtime = c(3,5))
}
\seealso{
\code{\link{ah}} for fitting the additive hazards model, \code{\link{nwtsco}} for
the description of nwtsco dataset
}

