% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_trials.R
\name{summarise_trials}
\alias{summarise_trials}
\title{Summarise results of multiple simulated trials to give the operating
  characteristics}
\usage{
summarise_trials(data, min_pos = 1, fut = 0)
}
\arguments{
\item{data}{list. Output from the \code{\link{multi_trial}} function.}

\item{min_pos}{integer. The minimum number of reference positive cases before
stopping is allowed. Default is \code{min_pos = 1}.}

\item{fut}{scalar. A probability threshold at which the posterior predictive
probability of eventual success is compared to. If the probability is less
than \code{fut}, the trial stops for binding futility. Default is \code{fut
= 0}, which corresponds to no stopping for futility.}
}
\value{
A data frame of row length 1, with the following columns:

\itemize{
    \item{\code{power}:} Power is defined as the proportion of trials that
    result in success, irrespective of whether it is an early stop for
    success or not. Trials that stop for futility, but which subsequently go
    on to be successful, are not considered as a success. In other words, the
    futility decision is binding, and in practice, if a trial triggered a
    futility rule, the sponsor would not see the eventual outcome if the
    trial were to continue enrolling. When the performance goals are set
    equal to the respective true values, the power returned is the type I
    error.
    \item{\code{stop_futility}:} The proportion of trials that stopped early
    for expected futility.
    \item{\code{n_avg}:} The average sample size for trials at the stage they
    stopped.
    \item{\code{sens}:} The average sensitivity for trials at the stage they
    stopped.
    \item{\code{spec}:} The average specificity for trials at the stage they
    stopped.
    \item{\code{mean_pos}:} The average number of reference positive cases
    for trials at the stage they stopped.
}
}
\description{
Summarise results of multiple simulated trials to give the operating
  characteristics
}
\examples{
data <- multi_trial(
    sens_true = 0.9,
    spec_true = 0.95,
    prev_true = 0.1,
    endpoint = "both",
    sens_pg = 0.8,
    spec_pg = 0.8,
    prior_sens = c(1, 1),
    prior_spec = c(1, 1),
    prior_prev = c(1, 1),
    succ_sens = 0.95,
    succ_spec = 0.95,
    n_at_looks = c(200, 400, 600, 800, 1000),
    n_mc = 10000,
    n_trials = 20,
    ncores = 1
    )

summarise_trials(data, fut = 0.05, min_pos = 10)
}
