\name{predict.ada}
\alias{predict.ada}

\title{
Predict a data set using Ada
}

\description{
\code{predict} classifies a new set of observations from a 
previously built classifier.  This function will provide either 
a vector of new classes, class probability estimates, or both.
}

\usage{
\method{predict}{ada}(object, newdata, type = c("vector", "probs", "both","F"),n.iter=NULL,\dots)
}

\arguments{
  \item{object}{object generated by \code{ada}.}
  \item{newdata}{new data set to predict.  This data set must be
    of type \sQuote{data.frame} and prediction data set is required 
    for this approach.}
  \item{type}{choice for preditions.  
    type=\dQuote{vector} returns the default class labels.
    type=\dQuote{prob} returns the probability class estimates.
    type=\dQuote{both} returns both the default class labels and
    probability class estimates.
    type=\dQuote{F} returns the ensamble average, where the class
    label is sign(F).  This is mainly usefull for the multiclass case.
    }
  \item{n.iter}{number of iterations to consider for the prediction.  By default
    this is iter from the \code{ada} call (n.iter< iter)}
  \item{\dots}{other arguments not used by this function.}
}

\details{
This function was modeled after \code{predict.rpart}.  Furthermore,
\code{predict.rpart} will be invoked to handle predictions by each tree in
the ensamble. 
}

\value{
  \item{fit}{a vector of fitted responses.  Fit will be returned if type=\dQuote{vector}.
  }
  \item{probs}{a matrix of class probability estimates. The first column 
    corresponds to the first label in the \sQuote{levels} of the response.  The second 
    column corresponds to the second label in the \sQuote{levels} of the response.  
    Probs are returned whenever type=\dQuote{probs}.
  }
  \item{both}{returns both the vector of fitted responses and class probability
    estimates.  The first element returns the fitted responses and will be labeled
    as \sQuote{class}.  The second element returns the class probability estimates 
    and will be labeled as \sQuote{probs}.
  }
  \item{F}{this is used in the multiclass case when one uses the package to perform 1 v.s. all.}
}

\note{
This function is invoked by the \code{summary}, \code{pairs}, and 
\code{plot} S3 generics invoked with an \code{ada} object.  If an error occurs in one of the above
commands then try using this command directly to track possible errors.
Also, the newdata data set must be of type \sQuote{data.frame} when invoking
\code{summary}, \code{pairs}, and \code{plot}.
}
\seealso{
    \code{\link{ada.default}},\code{\link{summary.ada}},\code{\link{print.ada}},
  \code{\link{plot.ada}},\code{\link{pairs.ada}},\code{\link{update.ada}},\code{\link{addtest}}
}
\keyword{methods}
