% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{getSpeeds}
\alias{getSpeeds}
\title{Extract speeds from the analysis results.}
\usage{
getSpeeds(
  input,
  type = c("all", "forward", "backward"),
  direct = FALSE,
  n.events = c("first", "all", "last")
)
}
\arguments{
\item{input}{An actel results object generated by \code{\link{explore}}, \code{\link{migration}} or \code{\link{residency}}.}

\item{type}{The type of movements to record. One of "all", "forward", or "backward". In the two last options,
only the forward or backwards (relatively to the study area structure) movement speeds are returned.}

\item{direct}{Logical: Extract only speeds between arrays that are directly connected (i.e. neighbouring arrays)?}

\item{n.events}{The events to record. One of "first", "all", or "last".}
}
\value{
A data frame with the following columns:
\itemize{
\item Tag: The tag of the animal who performed the recorded speed
\item Event: The valid event where the speed was recorded
\item From.array: The array from which the tags left
\item From.station: The station from which the tags left
\item To.array: The array to which the tags arrived
\item To.station: The station to which the tags arrived
\item Speed: The speed recorded in the described movement
}
}
\description{
Extract speeds from the analysis results.
}
\examples{
# using the example results loaded with actel
getSpeeds(example.results)

# You can specify which direction of movement to extract with 'type'
getSpeeds(example.results, type = "forward")
# or
getSpeeds(example.results, type = "backward")

# and also how many events per tag (this won't change the output 
# with the example.results, only because these results are minimal).
getSpeeds(example.results, n.events = "first")
# or
getSpeeds(example.results, n.events = "all")
# or
getSpeeds(example.results, n.events = "last")

}
