% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CJS.R
\name{dualArrayCJS}
\alias{dualArrayCJS}
\title{Calculate estimated last-array efficiency}
\usage{
dualArrayCJS(input)
}
\arguments{
\item{input}{A presence/absence matrix.}
}
\value{
A list containing:
\itemize{
\item \code{absolutes} A matrix with the absolute number of tags detected at each replicate and at both,
\item \code{single.efficiency} A vector of calculated array detection efficiencies for each of the replicates,
\item \code{combined.efficiency} The value of the combined detection efficiency for the array.
}
}
\description{
Calculate estimated last-array efficiency
}
\examples{
# prepare a dummy presence/absence matrix
x <- matrix(c(TRUE, TRUE, TRUE, TRUE, FALSE, TRUE), ncol = 2)
colnames(x) <- c("R1", "R2")

# run CJS
dualArrayCJS(x)

}
\references{
Perry et al (2012), 'Using mark-recapture models to estimate survival from telemetry data'. url: \url{https://www.researchgate.net/publication/256443823_Using_mark-recapture_models_to_estimate_survival_from_telemetry_data}
}
