% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifetable_function.R
\name{lifetable}
\alias{lifetable}
\title{Lifetable Function}
\usage{
lifetable(
  data,
  age,
  pop,
  deaths,
  includeAllSteps = TRUE,
  includeCDR = TRUE,
  includePS = TRUE,
  ...
)
}
\arguments{
\item{data}{The mortality dataset, includes an age grouping variable,}

\item{age}{The age grouping variable, must be categorical}

\item{pop}{Population of each age group, must be numeric}

\item{deaths}{The midyear number of deaths at each age group, must be numeric}

\item{includeAllSteps}{If false, will only include the proportion surviving to age x and life expectancy for age x}

\item{includeCDR}{If true, will include the central death rate for each age group}

\item{includePS}{If true, will include the proportion surviving for each age group}

\item{...}{Other optional grouping variables (can be race, gender, etc.)}
}
\value{
Lifetable
}
\description{
Gives user more control over their lifetable compared to the life_expectancy() function.
Allows the user to add in the central death rate and proportion surviving to age x.
Allows the user to omit accessory columns which are used to calculate life expectancy.
}
\examples{
# Running lifetable() and choosing not to include CentralDeathRate and
# ProportionToSurvive (optional columns) in the output dataset

lifetable(mortality2, "age_group", "population", "deaths", FALSE, TRUE, TRUE)
}
