% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizetest.R
\name{normalizetest}
\alias{normalizetest}
\title{Normalize training data}
\usage{
normalizetest(Xtst, Xn)
}
\arguments{
\item{Xtst}{a matrix with the test data with observations down the rows and variables in the columns.}

\item{Xn}{List with the output from normalize(Xtr) of the training data.}
}
\value{
\code{normalizetest} returns the normalized test data \code{Xtst}
}
\description{
Normalize test data using output from the \code{normalize()} of the training data
}
\details{
This function can e.g. be used for the test data in the \code{\link{predict.ASDA}} function.
}
\examples{
## Data
Xtr<-matrix(sample(seq(3),12,replace=TRUE),nrow=3)
Xtst<-matrix(sample(seq(3),12,replace=TRUE),nrow=3)

## Normalize training data
Nm<-normalize(Xtr)

## Normalize test data
Xtst<-normalizetest(Xtst,Nm)

}
\references{
Clemmensen, L., Hastie, T. and Ersboell, K. (2008)
"Sparse discriminant analysis", Technical report, IMM, Technical University of Denmark
}
\seealso{
\code{\link{normalize}}, \code{\link{predict.ASDA}}, \code{\link{ASDA}}
}
\author{
Line Clemmensen
}
