% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SDAAP.R
\name{SDAAP}
\alias{SDAAP}
\alias{SDAAP.default}
\title{Sparse Discriminant Analysis solved via Accelerated Proximal Gradient}
\usage{
SDAAP(Xt, ...)

\method{SDAAP}{default}(
  Xt,
  Yt,
  Om,
  gam,
  lam,
  q,
  PGsteps,
  PGtol,
  maxits,
  tol,
  selector = rep(1, dim(Xt)[2]),
  initTheta,
  bt = FALSE,
  L,
  eta,
  rankRed = FALSE,
  ...
)
}
\arguments{
\item{Xt}{n by p data matrix, (not a data frame, but a matrix)}

\item{Yt}{n by K matrix of indicator variables (Yij = 1 if i in class j).
This will later be changed to handle factor variables as well.
Each observation belongs in a single class, so for a given row/observation,
only one element is 1 and the rest is 0.}

\item{Om}{p by p parameter matrix Omega in generalized elastic net penalty.}

\item{gam}{Regularization parameter for elastic net penalty.}

\item{lam}{Regularization parameter for l1 penalty, must be greater than zero.}

\item{q}{Desired number of discriminant vectors.}

\item{PGsteps}{Maximum number if inner proximal gradient algorithm for finding beta.}

\item{PGtol}{Stopping tolerance for inner APG method.}

\item{maxits}{Number of iterations to run}

\item{tol}{Stopping tolerance for proximal gradient algorithm.}

\item{selector}{Vector to choose which parameters in the discriminant vector will be used to calculate the
regularization terms. The size of the vector must be *p* the number of predictors. The
default value is a vector of all ones. This is currently only used for ordinal classification.}

\item{initTheta}{Option to set the initial theta vector, by default it is a vector of all ones
for the first theta.}

\item{bt}{Boolean to indicate whether backtracking should be used, default false.}

\item{L}{Initial estimate for Lipshitz constant used for backtracking.}

\item{eta}{Scalar for Lipshitz constant.}

\item{rankRed}{Boolean indicating whether Om is in factorized form, such that R^t*R = mO}
}
\value{
\code{SDAAP} returns an object of \code{\link{class}} "\code{SDAAP}" including a list
with the following named components:

\describe{
  \item{\code{call}}{The matched call.}
  \item{\code{B}}{p by q matrix of discriminant vectors.}
  \item{\code{Q}}{K by q matrix of scoring vectors.}
  \item{\code{subits}}{Total number of iterations in proximal gradient subroutine.}
  \item{\code{totalits}}{Number coordinate descent iterations for all discriminant vectors}
}

\code{NULL}
}
\description{
Applies accelerated proximal gradient algorithm to
the optimal scoring formulation of sparse discriminant analysis proposed
by Clemmensen et al. 2011.
}
\seealso{
\code{SDAAPcv}, \code{\link{SDAP}} and \code{\link{SDAD}}
}
\keyword{internal}
