% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_retweeted_by.R
\name{get_retweeted_by}
\alias{get_retweeted_by}
\title{Get users who has retweeted a tweet}
\usage{
get_retweeted_by(
  x,
  bearer_token = get_bearer(),
  data_path = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{string containing one tweet id or a vector of tweet ids}

\item{bearer_token}{string, bearer token}

\item{data_path}{string, if supplied, fetched data can be saved to the designated path as jsons}

\item{verbose}{If \code{FALSE}, query progress messages are suppressed}
}
\value{
a data frame
}
\description{
This function fetches users who retweeted a tweet
}
\examples{
\dontrun{
tweets <- c("1392887366507970561","1409931481552543749")
get_retweeted_by(tweets, bearer_token = get_bearer())
}
}
