% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ab_methods.R
\name{ab-methods}
\alias{ab-methods}
\alias{summary.ab}
\alias{print.summary.ab}
\alias{print.ab}
\alias{plot.ab}
\title{Methods for ab objects}
\usage{
\method{summary}{ab}(object, digits = 3, raw = FALSE, ...)

\method{print}{summary.ab}(x, ...)

\method{print}{ab}(x, ...)

\method{plot}{ab}(x, ...)
}
\arguments{
\item{object, x}{object of class \code{ab} as returned from
\code{\link{ab_test}}.}

\item{digits}{number of digits to print for the summary.}

\item{raw}{if \code{TRUE}, the raw posterior samples are used to estimate the
mean, sd, and quantiles for the summary of the posterior. If \code{FALSE},
parametric fits to the marginal posteriors are used to obtain the mean, sd,
and quantiles. Specifically, a normal distribution is fitted for \code{psi
(logor)} and \code{beta}; a log-normal distribution is fitted for \code{or}
and \code{rrisk}; beta distributions are fitted for \code{p1} and
\code{p2}; a scaled beta distribution is fitted for \code{arisk}. These
distributional fits are also used in \code{\link{plot_posterior}}.}

\item{...}{further arguments, currently ignored.}
}
\value{
The \code{print} methods prints the Bayes factors, prior
  probabilities of the hypotheses, and posterior probabilities of the
  hypotheses (and returns nothing).

  The \code{plot} method visualizes the prior probabilities of the hypotheses
  and posterior probabilities of the hypotheses (the next plots is obtained
  by hitting Return) using the \code{\link{prob_wheel}} function.

  The \code{summary} methods returns the \code{ab} object that is guaranteed
  to contain posterior samples (i.e., it adds posterior samples if they were
  not included already). Additionally, it adds to the object a posterior
  summary matrix (i.e., \code{ab$post$post_summary}) for the posterior under
  H1 and the arguments \code{digits} (used for printing) and \code{raw}
  (added to \code{ab$input}).
}
\description{
Methods defined for objects returned from the \code{\link{ab_test}} function.
}
