% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abnormality.R
\name{overall_abnormality}
\alias{overall_abnormality}
\title{Measure a Subject's Abnormality with Respect to a Reference Population}
\usage{
overall_abnormality(Subj, Ref, stopping_rule = "Kaiser-Guttman",
  dist_measure = "MAD", TVE = 1, k = 2)
}
\arguments{
\item{Subj}{a vector of length n}

\item{Ref}{an n x p matrix containing the reference population.}

\item{stopping_rule}{the stopping rule to use when deciding the number of principal components to retain. Options include: c("Kaiser-Guttman", "brStick","TVE").}

\item{dist_measure}{the aggregate distance measure to use. Options include: c("MAD", "Euclidean", Manhattan","RMSE", "Lk-Norm")}

\item{TVE}{a numeric value between 0 and 1. The minimum total variance explained for the retained principal components. This will only be used if "TVE" is chosen as the stopping_rule.}

\item{k}{the value of k if Lk-Norm is chosen as a distance measure}
}
\value{
An unbiased measure of overall abnormality of the subject as compared to the reference population based on the parameters supplied.
}
\description{
Measure a Subject's Abnormality with Respect to a Reference Population
}
\examples{
p = 100
Subj <- rep(1, p)
Reference_Population <- generate_correlated_matrix(100, p, corr = 0.75,constant_cov_matrix = TRUE)
overall_abnormality(Subj,Reference_Population)
overall_abnormality(Subj,Reference_Population,dist_measure = "Euclidean")
overall_abnormality(Subj,Reference_Population,stopping_rule = "TVE", TVE = .90)
overall_abnormality(Subj,Reference_Population,dist_measure = "Lk-Norm",k=.5,stopping_rule="brStick")

}

