% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_components.R
\name{jaccard_components}
\alias{jaccard_components}
\alias{jaccard_turnover}
\alias{jaccard_nestedness}
\alias{sorenson_turnover}
\alias{sorenson_nestedness}
\title{Nestedness and turnover components for presence/absence data}
\usage{
jaccard_turnover(x, y)

jaccard_nestedness(x, y)

sorenson_turnover(x, y)

sorenson_nestedness(x, y)
}
\arguments{
\item{x, y}{Numeric vectors}
}
\value{
The nestedness or turnover component of distance between \code{x}
  and \code{y}. This quantity is undefined when either \code{x} or \code{y}
  have no observations, in which case we return \code{NaN}.
}
\description{
Nestedness and turnover components for presence/absence data
}
\references{
Baselga A. Partitioning the turnover and nestedness components of beta
diversity. Global Ecol. Biogeogr. 2010;19:134-143.

Baselga A. The relationship between species replacement, dissimilarity
derived from nestedness, and nestedness. Global Ecol. Biogeogr.
2012;21:1223–1232.
}
