% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest.fold.R
\docType{class}
\name{VT.forest.fold}
\alias{VT.forest.fold}
\title{Difft via k random forests}
\description{
A reference class to compute twins via k random forest
}
\details{
\code{VT.forest.fold} extends \code{VT.forest}

Twins are estimated by k-fold cross validation. A forest is computed on k-1/k
of the data and then used to estimate twin1 and twin2 on 1/k of the left 
data.
}
\section{Fields}{

\describe{
\item{\code{interactions}}{logical set TRUE if model has been computed with 
interactions}

\item{\code{fold}}{numeric, number of fold, i.e. number of forest (k)}

\item{\code{ratio}}{numeric experimental, use to balance sampsize. Defaut to 1.}

\item{\code{groups}}{vector Define which observations belong to which group}

\item{\code{...}}{field from parent class : \code{\link{VT.forest}}}
}}

\section{Methods}{

\describe{
\item{\code{run()}}{Compute twin1 and twin2 estimation. Switch treatment if necessary.}
}}

\seealso{
\code{\link{VT.difft}}, \code{\link{VT.forest}}, 
  \code{\link{VT.forest.one}}, \code{\link{VT.forest.double}}
}
