% Generated by roxygen2 (4.0.2): do not edit by hand
\name{ts.diag}
\alias{ts.diag}
\title{Diagnostics for ARIMA fits}
\usage{
ts.diag(object, lag.seq = NULL)
}
\arguments{
\item{object}{the result of an \code{arima} or \code{estimate} fit.}

\item{lag.seq}{the sequence of lag to calculate the Ljung-Box test statistics. The default
is \code{NULL}.}
}
\value{
A matrix for the result of white noise checking by Ljung-Box test.
}
\description{
Performs diagnostics for ARIMA model fitted by \code{\link{arima}} or
\code{\link{estimate}} with output of diagnostic plots.
}
\details{
This function is similar to \code{\link{ts.diag}} in \code{stats} package, but with
one more diagnostic plot for the normality of residuals. Also, the default sequence of lags
for a Ljung-Box test is set to be \code{seq(4,24,by = 4)} if sample size \eqn{n > 24},
otherwise \code{seq(1,n,4)}. This function has been automatically implemented in
\code{\link{estimate}} function.

Diagnostics are plotted, including the ACF plot, PACF plot, p.value of
white noise checking plot, and Q-Q plot for residuals.
}
\examples{
x <- arima.sim(list(order = c(3,0,0),ar = c(0.2,0.4,-0.15)),n = 100)
fit <- estimate(x,p = 3) # same as fit <- arima(x,order = c(3,0,0))
ts.diag(fit)
}
\author{
Debin Qiu
}

