% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maize.muchow.model.r
\name{mm.LN.fct}
\alias{mm.LN.fct}
\title{Leaf number function for Muchow et al. (1990) Maize model}
\usage{
mm.LN.fct(TT1, TTE, b1 = 2.5, b2 = 0.00225, TLN = 20)
}
\arguments{
\item{TT1}{: Thermal time from sowing (degC.day)}

\item{TTE}{: Thermal units from sowing to emergence/leaf growth (degC.day)}

\item{b1}{: coefficient of the statistical relation (default : 2.5)}

\item{b2}{: coefficient of the statistical relation (default : 0.00225)}

\item{TLN}{: total number of leaves initiated (-)}
}
\value{
Leaf number
}
\description{
Leaf number as a function of thermal time
}
\examples{
plot(1:1000,mm.LN.fct(1:1000,TTE=87))
}
\seealso{
\code{\link{maize.muchow.model}}, \code{\link{mm.A.fct}}, \code{\link{mm.FAS.fct}}, \code{\link{maize.multisy}},
\code{\link{mm.HI.fct}},\code{\link{maize.muchow.graph}}
}
