% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mut_info_knn.R
\name{mut_info_knn}
\alias{mut_info_knn}
\title{Mutual Information for Continuous Variables using kNN}
\usage{
mut_info_knn(x, y, k = 5, direct = TRUE)
}
\arguments{
\item{x}{Numeric vector.}

\item{y}{Numeric vector.}

\item{k}{Number of nearest neighbors to use; default is 5.}

\item{direct}{Logical; if \code{TRUE}, mutual information is calculated
using the k-nearest neighbors (kNN) estimator; if \code{FALSE}, it is computed
via entropy estimates as \eqn{I(X;Y) = H(X) + H(Y) - H(X,Y)}. Default is \code{TRUE}.}
}
\value{
Numeric; an estimate of the mutual information.
}
\description{
Mutual Information for Continuous Variables using kNN
}
\examples{
set.seed(123)
x <- rnorm(1000)
y <- rnorm(1000)
# Close to 0 if they are independent
mut_info_knn(x, y, k = 5)
y <- 100 * x + rnorm(length(x), 0, 12)
# Far from 0 if they are not independent
mut_info_knn(x, y, k = 5)
}
