% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bins.r
\name{get_bins}
\alias{get_bins}
\title{A function to binarize a numeric vector with a given resolution}
\usage{
get_bins(x, x_min, x_max, res)
}
\arguments{
\item{x}{numeric, the vector to be binarized}

\item{x_min}{numeric, the min value of a vector to create the bins (e.g., 0)}

\item{x_max}{numeric, the maximum value of the vector x to binarize}

\item{res}{numeric, the resolution; if x is time, res can be 1 s}
}
\value{
the vector of bins for which x is in
}
\description{
A function to binarize a numeric vector with a given resolution
}
\examples{
x <- 1:20
get_bins(x, 0, 20, 5)
# Returns
# [1]  5  5  5  5  5 10 10 10 10 10 15 15 15 15 15 20 20 20 20 20
# set.seed(10)
x <- runif(20, 0, 10)
get_bins(x, 0, 10, 0.5)
# Returns
# 1] 5.5 3.5 4.5 7.0 1.0 2.5 3.0 3.0 6.5 4.5 7.0 6.0 1.5 6.0 4.0 4.5 1.0 3.0 4.0 8.5
}
