% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_bout.R
\name{biexponential}
\alias{biexponential}
\title{Biexponential Model}
\usage{
biexponential(irt)
}
\arguments{
\item{irt}{A numeric vector representing inter-response times.}
}
\value{
A data frame with estimated parameters \eqn{w} (proportion of responses in bouts), \eqn{l0} (within-bout mean IRT),
and \eqn{l1} (between-bout mean IRT).
}
\description{
Implements a simpler biexponential model without the refractory period parameter, \eqn{\delta}.

The simpler model is defined as:
\deqn{p(IRT = \tau) = p w e^{-w \tau} + (1 - p) b e^{-b \tau}}
where \eqn{w} and \eqn{b} represent the within- and between-bout response rates, and \eqn{p} is the proportion of responses in bouts.
}
\examples{
set.seed(43)
l1 <- 1 / 0.5
l2 <- 1 / 0.1
p <- 0.4
n <- 200
irt <- c(rexp(round(n * p), l1), rexp(round(n * (1 - p)), l2))
biexponential(irt)

}
