# Finds if true.value is in interval.
# Will generate a vector of integers from 0 to 2,
# corresponding to the domains generated by the two limits.

#' True value in interval
#'
#' @param df A data frame containing the intervals to be evaluated. Each row should
#' correspond to an interval with lower and upper limits.
#' @param lowLim the column index or name in the data frame `df`
#' corresponding to the lower limit of the interval.
#' @param upLim the column index or name in the data frame `df`
#' corresponding to the upper limit of the interval.
#' @param true.val the true value to be checked if it falls within
#' the interval defined by `lowLim` and `upLim`.
#'
#' @return A numeric vector of n elements with an integer value
#' for each interval: 0 if the value is below the interval,
#' 1 if it is inside the interval (with a rightmost open limit),
#' and 2 if it is above the interval.
#' @export
#'
#' @examples
#' # Example data frame with intervals
#' df <- data.frame(lower = c(1, 5, 10), upper = c(3, 8, 15))
#'
#' # Check if the value 6 is within any of the intervals
#' val_in_interval(df, "lower", "upper", 6)
val_in_interval <- function(df, lowLim, upLim, true.val) {
  apply(
    df[, c(lowLim, upLim)],
    1, function(x) {
      if (any(is.na(x))) {
        return(NA)  # Return NA for unspecified intervals
      }
      if (!any(is.na(x))){
        x <- sort(x)
      }
      findInterval(true.val, x)
    }
  )
}
