% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Interface.R
\docType{class}
\name{AssignedProxy-class}
\alias{AssignedProxy-class}
\alias{AssignedProxy}
\title{Class for Assigned Proxy Objects and Related Mechanisms}
\description{
The `AssignedProxy` class is used by interface packages to return a reference
to an assigned server object.  The \R user can then supply this object anywhere
in later interface computations, just as one would use the name of an \R object
in a function call or other expression.
}
\details{
The virtual class `ProxyObject` is a superclass, designed to allow
other mechanisms for proxy objects (none exists at this time).
}
\section{Slots}{

\describe{
\item{\code{.Data}}{The `AssignedProxy` class is a subclass of `character`; the actual character string
will be generated by the interface and is unique over the session, so long as the `XR`
package stays loaded.}

\item{\code{serverClass,module}}{The server language class and module for the corresponding object.}

\item{\code{size}}{The size (usually, length) of the server object, if that makes sense.
Can be used to make decisions about handling large objects.}

\item{\code{evaluator}}{The evaluator object that returned the proxy.  Having this as a slot allows
interface computations to operate directly on the proxy, without a user-supplied evaluator.}
}}

\references{
Chambers, John M. (2016)
\emph{Extending R},
Chapman & Hall/CRC.
( Chapter 13, discussing this package, is included in the package: \url{../doc/Chapter_XR.pdf}.)
}
