% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FRpredcorhalf.R
\name{FRpredcorhalf}
\alias{FRpredcorhalf}
\title{Compute the FR half coefficient  on two vectors based on half Gamma 2.}
\usage{
FRpredcorhalf(xvec, yvec, tiemethod = "average")
}
\arguments{
\item{xvec}{Vector of numeric values in the first coordinate.}

\item{yvec}{Vector of numeric values in the second coordinate.}

\item{tiemethod}{Choice of treatment for ties, default is the "average"}
}
\value{
In the case simple = TRUE, function returns the value of the
        FR standardized coefficient.
}
\description{
This function computes the unidimensional ranked
half graph prediction coefficient
between two vectors xvec and yvec.
}
\note{
Auxiliary function with no checks for NA, etc.
}
\examples{
# Compute  the coefficient and compare to the xi coefficient
simulCompare <- function(n = 20, B = 1000)
{
 diffsim <- rep(0,B)
 xvec <- 1:n
 for (i in 1:B)
 {
   yvec <- sample(n,n)
   diffsim[i] <- FRpredcorhalf(xvec,yvec)-xicor(xvec,yvec)
 }
 return(diffsim)
 }

 compare1K <- simulCompare()
 summary(compare1K)


}
\references{
Chatterjee, S. and Holmes, S (2020)
Practical observations and applications of the robust prediction
coefficient.
}
\seealso{
xicor FRpredcor
}
\author{
Sourav Chatterjee, Susan Holmes
}
\keyword{~methods}
