# List of color palettes currently available


#' Complete list of palettes.
#'
#' Use names(WrensBookshelf) to display all possible palette names. Current available palettes:
#' \code{BabyBeluga}, \code{BabyWrenAndTheGreatGift}, \code{BlueberriesForSal}, \code{BoTheBrave},
#' \code{BoTheBraveCVDS}, \code{BurtDow}, \code{BurtDowCVDS}, \code{CapsForSale}, \code{GustavoTheShyGhostCover},
#' \code{GustavoTheShyGhostGraveyard}, \code{HaroldAndThePurpleCrayon}, \code{JeffGoesWild},
#' \code{JulienIsAMermaid}, \code{LittleBlueHouseBesideTheSeaCont}, \code{LittleBlueHouseBesideTheSeaDisc},
#' \code{Madelline}, \code{MakeWayForDucklings}, \code{MoreThanALittle}, \code{OhThePlacesYoullGo},
#' \code{Opposites}, \code{StackTheCats}, \code{TheDucklingGetsACookie}, \code{TheHoneybee},
#' \code{TheHoneybeeDiverging}, \code{ThePoutPoutFish}, \code{TheSnowyDay}, \code{TheStoryOfBabar},
#' \code{TheseWordsIShapedForYou}, \code{ThisMooseBelongsToMe}, \code{ThreeLittleVikings}, \code{TigerDays},
#' \code{TinyPerfectThings}, \code{Vampenguin}, \code{WhatWellBuild}, \code{WhereTheWildThingsAre}, and \code{YouMatter}.
#'
#' @return No return value, sets a list of palettes to be used with WrensBookshelf functions
#' @export
WrensBookshelf <- list(
  TigerDays = list(c("#3d85a3","#e6c74a","#6a2124","#614e46","#bf4b34","#bf798d","#bbbdc2","#5b6e97","#5b7d30","#9c84b3"),
                   c(1,2,3,4,5,6,7,8,9,10),
                   CVDsafe=FALSE,
                   BestFor="discrete",
                   Author="M.H. Clark"),
  BoTheBrave = list(c("#039b9e","#a6cdcc","#e069a3","#ecacce","#f48347","#ccc8c9","#080808"),
                    c(1,5,2,4,3,6,7),
                    CVDsafe = FALSE,
                    BestFor = "discrete",
                    Author = "Bethan Woolvin"),
  BoTheBraveCVDS = list(c("#039b9e","#e069a3","#f48347","#ccc8c9","#080808"),
                        c(1,2,3,4,5),
                        CVDsafe = TRUE,
                        BestFor = "discrete",
                        Author = "Bethan Woolvin"),
  BurtDow = list(c("#a3474c","#dc659f","#e2b0bc","#ecb485","#b7a28d","#f8eb79","#89bfa8","#62af83"),
                 c(6,2,8,1,3,4,5,7),
                  CVDsafe = FALSE,
                  BestFor = "discrete",
                  Author = "Robert McCloskey"),
  BurtDowCVDS = list(c("#62af83","#f8eb79","#e2b0bc","#dc659f","#a3474c"),
                     c(2,4,1,5,3),
                       CVDsafe= TRUE,
                       BestFor = "discrete",
                       Author = "Robert McCloskey"),
  BlueberriesForSal = list(c("#f6c34b", "#e1d17c", "#e2d4d9",
                               "#575f74", "#263f67"),
                             c(1, 5, 3, 2, 4),
                             CVDsafe= TRUE,
                             BestFor = "continuous",
                             Author = "Robert McCloskey"),
  GustavoTheShyGhost1 = list(c("#9b1c52",  "#ec008c", "#f16d99", "#ef4823",
                                         "#f7931e", "#69a3ba", "#869093", "#c2afa1"),
                                       c(2, 6, 5, 1, 3, 7, 4, 8),
                                       CVDsafe= FALSE,
                                       BestFor = "discrete",
                                       Author = "Flavia Z. Drago"),
  GustavoTheShyGhost2 = list(c("#061f1e", "#062e36", "#20555a", "#3ba19f", "#a7dbd6",
                                             "#fcf6fa", "#dda7bb", "#dd7f65", "#e64939", "#ab1d31", "#5e0d27"),
                                           c(2, 10, 3, 9, 4, 8, 5, 7, 1, 6, 11),
                                           CVDsafe= TRUE,
                                           BestFor = "continuous",
                                           Author = "Flavia Z. Drago"),
  JulienIsAMermaid = list(c("#73644b", "#c98d49", "#dd9b27", "#ecb21f", "#81c07e",
                               "#00aeb9", "#0067a9", "#22576e",  "#86538c",
                               "#89172d",  "#b4202c"),
                             c(2, 10, 3, 9, 4, 8, 5, 7, 1, 6, 11),
                             CVDsafe= FALSE,
                             BestFor = "discrete",
                             Author = "Jessica Love"),
  MakeWayForDucklings = list(c("#523113", "#933a1f", "#ebe6b5", "#4e9665"),
                                c(1, 4, 3, 2),
                                CVDsafe= TRUE,
                                BestFor = "continuous",
                                Author = "Robert McCloskey"),
  WhereTheWildThingsAre = list(c("#5a6f77", "#959690", "#301113",
                                     "#c6856b", "#b6d8a2", "#e2da92"),
                                   c(1, 4, 3, 5, 2, 6),
                                   CVDsafe= FALSE,
                                   BestFor = "discrete",
                                   Author = "Maurice Sendak"),
  CapsForSale = list(c("#deb136", "#fcb330", "#f1592f", "#e0e1da",
                         "#bfe6ec", "#94d0c3", "#5f5743"),
                       c(2, 6, 3, 7, 4, 1, 5),
                       CVDsafe= FALSE,
                       BestFor = "discrete",
                       Author = "Esphyr Slobodkina"),
  TheHoneybee2 = list(c("#26221a", "#a49870", "#ebe6b5", "#fef59f", "#ffc10e", "#fbaa19"),
                                  c(1, 6, 2, 5, 3, 4),
                                  CVDsafe= TRUE,
                                  BestFor = "continuous",
                                  Author = "Isabelle Arsenault"),
  TheHoneybee1 = list(#c("#26221a", "#a49870", "#ebe6b5", "#fbaa19", "#ffc10e", "#fef59f","#f1e902", "#dfe227", "#9ad3b1", "#f179af", "#ee4180", "#ed1b34"),
                     c("#a49870","#fbaa19","#fef59f","#f1e902","#9ad3b1","#ee4180"),
                      #c(1, 5, 12, 2, 6, 9, 3, 4, 11, 7, 9, 8, 10),
                     c(2,5,1,6,4,3),
                      CVDsafe= FALSE,
                      BestFor = "discrete",
                      Author = "Isabelle Arsenault"),
  ThePoutPoutFish = list(c("#1c3c6b", "#0096be", "#97daf2", "#b1c6e6", "#ded5c0",
                              "#ffde7b", "#d87145", "#e85975", "#8d3f60"),
                            c(2, 8, 3, 7, 1, 6, 4, 9, 5),
                            CVDsafe= TRUE,
                            BestFor = "continuous",
                            Author = "Deborah Dieson and Dan Hanna (Ills.)"),
  StackTheCats = list(c("#0db9a6",  "#54c1ad",  "#d0eadd", "#fffffb",
                          "#ffc10e", "#f78f1e", "#f0502f"),
                        c(1, 7, 2, 6, 3, 5, 4),
                        CVDsafe = TRUE,
                        BestFor = "continuous",
                        Author = "Susie Ghahremani"),
  OhThePlacesYoullGo = list(c("#f7a5b0",  "#bfbbde",  "#00badd",
                                   "#b0d9a5", "#fbf284", "#fec04b"),
                                 c(4, 2, 5, 3, 6, 1),
                                 CVDsafe = TRUE,
                                 BestFor = "discrete",
                                 Author = "Dr. Seuss"),
  ThreeLittleVikings = list(c("#6359a6", "#ffc709", "#aea9ba",
                                "#ef4423", "#00aa8e", "#14130f"),
                              c(1, 2, 3, 4, 5, 6),
                              CVDsafe = TRUE,
                              BestFor = "discrete",
                              Author = "Bethan Woolvin"),
  TinyPerfectThings = list(c("#6d4523", "#934926", "#f1592d", "#f4b483", "#f9f7e4",
                               "#f0e904", "#e2bc23", "#968c33", "#55562f"),
                             c(1, 9, 2, 8, 3, 7, 4, 6, 5),
                             CVDsafe = FALSE,
                             BestFor = "continuous",
                             Author = "M.H. Clark and Madeline Kloepper (Ills.)"),
  TheDucklingGetsACookie = list(c("#d5bac2", "#e9ceb4", "#a5d8d8",
                                        "#f3e78a", "#d58454", "#c97c6d"),
                                      c(3, 4, 5, 1, 6, 2),
                                      CVDsafe = TRUE,
                                      BestFor = "discrete",
                                      Author = "Mo Willems"),
  BabyWrenAndTheGreatGift = list(c("#005e32",  "#5c833a", "#9aac4e", "#e0d81e", "#d9eddf",
                                        "#fde2d6", "#f8b0ad", "#f37d97", "#f05226"),
                                      c(1, 8, 2, 9, 3, 7, 4, 6, 5),
                                      CVDsafe = FALSE,
                                      BestFor = "continuous",
                                      Author = "Sally Lloyd-Jones and Jen Corace (Ills.)"),
  HaroldAndThePurpleCrayon = list(c("#912688",  "#e1d1c8", "#f6eee7"),
                                      c(1, 2, 3),
                                      CVDsafe = TRUE,
                                      BestFor = "continuous",
                                      Author = "Crockett Johnson"),
  BabyBeluga = list(c("#0069a7", "#008fc3", "#52c3c2", "#95d6d7", "#f1f4cd", "#ffffff"),
                     c(1, 5, 2, 4, 3, 6),
                     CVDsafe = TRUE,
                     BestFor = "continuous",
                     Author = "Raffi and Ashley Wolf (Ills.)"),
  Madelline = list(c("#4d84bc", "#f6eb00", "#ef3d23", "#00ab69",  "#17b8c5", "#552d20"),
                   c(1, 2, 3, 4, 5, 6),
                   CVDsafe = TRUE,
                   BestFor = "discrete",
                   Author = "Ludwig Bemelmans"),
  TheseWordsIShapedForYou = list(c("#00bdea", "#00afd3", "#f15523", "#ee2b2c",
                                        "#f9c6dc", "#f59fb6", "#ffd200", "#fdb813"),
                                      c(2, 4, 6, 8, 1, 3, 5, 7),
                                      CVDsafe = TRUE,
                                      BestFor = "discrete",
                                      Author = "Megan Merchant and Basak Agouglu"),
  Opposites = list(c("#1f455f", "#6b2e54", "#8f60a8", "#ffe100",
                     "#a3b439", "#4c5f2b"),
                   c(2, 4, 1, 5, 3, 6),
                   CVDsafe = FALSE,
                   BestFor = "discrete",
                   Author = "Merrilee Liddiard"),
  TheSnowyDay = list(c("#ee2424", "#ef4823", "#8e4422", "#f6d10e",
                         "#b886bb", "#fcdee5", "#a5bfb2", "#004f28"),
                       c(1, 4, 5, 8, 2, 6, 7, 3),
                       CVDsafe = FALSE,
                       BestFor = "discrete",
                       Author = "Ezra Jack Keats"),
  TheStoryOfBabar = list(c("#213569", "#0072ba", "#ebe9ee",
                              "#f9ef62", "#f15925"),
                            c(1, 5, 2, 4, 3),
                            CVDsafe = FALSE,
                            BestFor = "continuous",
                            Author = "Jean de Brunhoff"),
  YouMatter = list(c("#c92463","#d33f4e","#7794b6","#bfe2ef",
                     "#cab49a","#a89933","#00432b"),
                   c(4,1,6,7,2,5,3),
                    CVDsafe = FALSE,
                    BestFor = "discrete",
                    Author = "Christian Robinson"),
  MoreThanALittle = list(c("#2e6e57", "#6b6544", "#b8ac77",
                              "#e0d7b8", "#e8bb7f", "#e27b2d"),
                            c(1, 6, 2, 5, 3, 4),
                            CVDsafe = FALSE,
                            BestFor = "continuous",
                            Author = "M.H. Clark and Cecile Metzger (Ills.)"),
  Vampenguin = list(c("#4dc1b5", "#98d5cb", "#fad6d4", "#f6f6f6",
                      "#f8de70", "#f8c954", "#f19a30"),
                    c(1, 7, 2, 6, 3, 5, 4),
                    CVDsafe = FALSE,
                    BestFor = "continuous",
                    Author = "Lucy Ruth Cummins"),
  JeffGoesWild = list(c("#d91f2e", "#f37121", "#f4e304", "#00b14c", "#006f44",
                          "#003d51", "#007490", "#71cfec", "#cd7185", "#b62553"),
                        c(5, 10, 6, 9, 7, 1, 8, 2, 4, 3),
                        CVDsafe = FALSE,
                        BestFor = "discrete",
                        Author = "Angie Rozelaar"),
  ThisMooseBelongsToMe = list(c("#1b3e3f", "#265550", "#2d685f", "#4d8872", #"#8faf8b",
                                    "#a6b67f", #"#eacb92",
                                    "#e4b972", "#fcb662", "#fbae4e"),
                                  c(1, 8, 2, 7, 3, 6, 4, 5),
                                  CVDsafe = TRUE,
                                  BestFor = "continuous",
                                  Author = "Oliver Jeffers"),
  WhatWellBuild = list(c("#23366d", "#2863af", "#7985c1", "#ad93c5",
                            "#cea3b7", "#e8a899", "#fab07e", "#ffd08b"),
                          c(1, 8, 2, 7, 3, 6, 4, 5),
                          CVDsafe = TRUE,
                          BestFor = "continuous",
                          Author = "Oliver Jeffers"),
  LittleBlueHouseBesideTheSea1 = list(c("#008ba7", "#009db3", "#00aec4", "#26bdc2", "#8bd2d4", "#ade0ec",
                                                    "#d8f0f8", "#fde4dd", "#fac0bc", "#f79e97", "#f27178", "#ef4048", "#ba2426"),
                                                  c(1, 13, 2, 12, 3, 11, 4, 10, 5, 9, 6, 8, 7),
                                                  CVDsafe = TRUE,
                                                  BestFor = "continuous",
                                                  Author = "Jo Ellen Bogart and Carme Lemniscates (Ills.)"),
  LittleBlueHouseBesideTheSea2 = list(c("#004d59", "#0087a1", "#61c3aa",
                                                    "#fab899", "#e45153", "#700d32"),
                                                  c(2, 5, 3, 4, 1, 6),
                                                  CVDsafe = FALSE,
                                                  BestFor = "discrete",
                                                  Author = "Jo Ellen Bogart and Carme Lemniscates (Ills.)"),
  BatheTheCat = list(c("#00b8d7","#00b188","#ebe70f","#faa520","#f5a2c6","#f15743"),
                         c(1,4,2,5,3,6),
                         CVDsafe = FALSE,
                         BestFor = "discrete",
                         Author = "Alice B. McGinty and David Roberts (Ills.)"
  ),
  Moongame = list(c("#2f2a20","#6f361f","#0b3f48","#006a80","#005e37","#00794a","#ffd400","#e7e17c"),
                    c(1,7,3,5,2,8,4,6),
                    CVDsafe = FALSE,
                    BestFor = "discrete",
                    Author = "Frank Asche"
  ),
  TheRunawayBunny = list(c("#f0cab7","#e67585","#b3585c","#9a81bb","#9698cc","#a4bfe4","#dce790","#cfdf6b","#a2cf61"),
                             c(4,9,2,6,1,8,3,5,7),
                             CVDsafe = TRUE,
                             BestFor = "continuous",
                             Author = "Maragaret Wise Brown and Clement Hurd (Ills.)"
  ),
  LastStopOnMarketStreet = list(c("#cc3927","#c2544b","#e86c24","#f6d10e","#addcee","#809eba",#"#4a6e72","#4d647e",
                                  "#306580"),
                                c(3,7,2,6,1,5,4),
                                #c(3,9,2,6,1,8,4,7,5),
                                      CVDsafe = TRUE,
                                      BestFor = "continuous",
                                      Author = "Matt De La Pena and Christian Robinson (Ills.)"
  )
)

WrensBookshelf <- WrensBookshelf[order(names(WrensBookshelf))]
