% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webpower.R
\name{wp.t}
\alias{wp.t}
\title{Statistical Power Analysis for t-Tests}
\usage{
wp.t(n1 = NULL, n2 = NULL, d = NULL, alpha = 0.05, power = NULL,
  type = c("two.sample", "one.sample", "paired", "two.sample.2n"),
  alternative = c("two.sided", "less", "greater"),
  tol = .Machine$double.eps^0.25)
}
\arguments{
\item{n1}{Sample size of the first group.}

\item{n2}{Sample size of the second group if applicable.}

\item{d}{Effect size. See the book by \cite{Cohen (1988)} for details.}

\item{alpha}{Significance level chosed for the test. It equals 0.05 by default.}

\item{power}{Statistical power.}

\item{type}{Type of comparison (\code{"one.sample"} or \code{"two.sample"} or \code{"two.sample.2n"} or \code{"two.sample.2n"} or \code{"paired"}). "two.sample" is two-sample t-test with equal sample sizes, two.sample.2n" is two-sample t-test with unequal sample sizes, "paired" is paired t-test}

\item{alternative}{Direction of the alternative hypothesis (\code{"two.sided"} or \code{"less"} or \code{"greater"}). The default is "two.sided".}

\item{tol}{tolerance in root solver.}
}
\value{
An object of the power analysis.
}
\description{
A t-test is a statistical hypothesis test in which the test statistic follows a Student's t distribution if the null hypothesis is true and follows a non-central t distribution if the alternative hypothesis is true.
The t test can assess the statistical significance of (1) the difference between population mean and a specific value, (2) the difference between two independent populaion means, and (3) difference between means of matched paires.
}
\examples{
#To calculate the power for one sample t-test given sample size and effect size:
wp.t(n1=150, d=0.2, type="one.sample")
#  One-sample t-test
#
#	n   d alpha    power
#	150	0.2	0.05	0.682153
#
#  URL: http://psychstat.org/ttest

#To calculate the power for paired t-test given sample size and effect size:
wp.t(n1=40, d=-0.4, type="paired", alternative="less")
#  Paired t-test
#
#     n    d alpha     power
#    40 -0.4  0.05 0.7997378
#
#  NOTE: n is number of *pairs*
#  URL: http://psychstat.org/ttest

#To estimate the required sample size given power and effect size for paired t-test :
wp.t(d=0.4, power=0.8, type="paired", alternative="greater")
#  Paired t-test
#
#           n   d alpha power
#    40.02908 0.4  0.05   0.8
#
#  NOTE: n is number of *pairs*
#  URL: http://psychstat.org/ttest

#To estimate the power for balanced two-sample t-test given sample size and effect size:
wp.t(n1=70, d=0.3, type="two.sample", alternative="greater")
#  Two-sample t-test
#
#     n   d alpha     power
#    70 0.3  0.05 0.5482577
#
#  NOTE: n is number in *each* group
#  URL: http://psychstat.org/ttest

#To estimate the power for unbalanced two-sample t-test given sample size and effect size:
wp.t(n1=30, n2=40, d=0.356, type="two.sample.2n", alternative="two.sided")
#  Unbalanced two-sample t-test
#
#    n1 n2     d alpha     power
#    30 40 0.356  0.05 0.3064767
#
#  NOTE: n1 and n2 are number in *each* group
#  URL: http://psychstat.org/ttest2n

#To estimate the power curve for unbalanced two-sample t-test given a sequence of effect sizes:
res <- wp.t(n1=30, n2=40, d=seq(0.2,0.8,0.05), type="two.sample.2n",
                                             alternative="two.sided")
res
#  Unbalanced two-sample t-test
#
#    n1 n2    d alpha     power
#    30 40 0.20  0.05 0.1291567
#    30 40 0.25  0.05 0.1751916
#    30 40 0.30  0.05 0.2317880
#    30 40 0.35  0.05 0.2979681
#    30 40 0.40  0.05 0.3719259
#    30 40 0.45  0.05 0.4510800
#    30 40 0.50  0.05 0.5322896
#    30 40 0.55  0.05 0.6121937
#    30 40 0.60  0.05 0.6876059
#    30 40 0.65  0.05 0.7558815
#    30 40 0.70  0.05 0.8151817
#    30 40 0.75  0.05 0.8645929
#    30 40 0.80  0.05 0.9040910
#
#  NOTE: n1 and n2 are number in *each* group
#  URL: http://psychstat.org/ttest2n

#To plot a power curve:
plot(res, xvar='d', yvar='power') 
}
\references{
Cohen, J. (1988). Statistical power analysis for the behavioral sciences (2nd Ed). Hillsdale, NJ: Lawrence Erlbaum Associates.

Zhang, Z., & Yuan, K.-H. (2018). Practical Statistical Power Analysis Using Webpower and R (Eds). Granger, IN: ISDSA Press.
}
