% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoordBase.R
\name{op-zero-length}
\alias{op-zero-length}
\alias{\%L\%}
\title{Operator Providing Alternative to Zero-Length Object}
\usage{
x \%L\% y
}
\arguments{
\item{x, y}{atomic vector arguments or other objects for which \code{length()} is defined.}
}
\value{
\code{x}, or if \code{length(x)} is zero, \code{y}.
}
\description{
Infix function implementing provision of an alternative if an object has zero length.
}
\details{
The infix function \code{\%L\%} may be useful in implementing \code{if (length(x)) x else y} and
was inspired by the null coalescing operator \code{\link[base:Control]{\%||\%}}.
}
\examples{
c4 <- letters[1:4]
c0 <- character(0)
n3 <- 1:3
n0 <- numeric(0)

c4 \%L\% n3
c0 \%L\% n3

n3 \%L\% c4
n0 \%L\% c4

rm(c4, c0, n3, n0)
}
\seealso{
\code{\link[base:Control]{\%||\%}}.
}
\concept{utils}
\keyword{logic}
\keyword{programming}
