% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aSerfling.R
\name{aSerfling}
\alias{aSerfling}
\title{Adjusted Serfling}
\usage{
aSerfling(data, col_name, cycles)
}
\arguments{
\item{data}{A data frame containing the warning indicator columns, arranged in time-based order.}

\item{col_name}{A column name for the warning indicator (character).}

\item{cycles}{A numeric vector of disease cycles (e.g., c(52,26) for weekly annual + semi-annual patterns)}
}
\value{
A list containing:
\itemize{
  \item output: Full dataset with warning flags (1=alert, 0=normal)
  \item best_fit: Final lm model object
  \item fit_times: Iteration count for convergence
  \item cycles: Input cycle parameters
}
}
\description{
Adjusted Serfling regression for periodic disease surveillance, automating epidemic baseline
estimation through iterative threshold optimization. Enhances traditional Serfling models by objectively
determining epidemic periods and improving peak detection accuracy.
}
\details{
Implements an iterative periodic regression for time series with at least 2 full cycles. Key features:

\enumerate{
  \item Dynamic Epidemic Filtering:
  \itemize{
    \item Automatically excludes outbreak points via iterative prediction-CI comparison
    \item Terminates when adjusted R-squared stabilizes (maximized model fit)
  }

  \item Flexible Seasonality Modeling:
  \deqn{Y = \beta_0 + \beta_1 t + \beta_2 t^2 + \sum_{k=1}^K \left[\gamma_k \sin\left(\frac{2\pi t}{C_k}\right) + \delta_k \cos\left(\frac{2\pi t}{C_k}\right)\right] + \epsilon}
  \itemize{
    \item Supports multiple cycles via \code{cycles} parameter (e.g., c(52,26) for weekly annual + semi-annual patterns)
    \item Self-adapts to pathogen seasonality shifts
  }

  \item Peak-Centric Alerting:
  \itemize{
    \item Flags peaks via optimized threshold (final model's 95\% CI upper bound)
    \item Avoids subjective epidemic-onset definitions
  }
}
}
\examples{
## modeling
data(sample_ili)
sf <- aSerfling(data = sample_ili, 'case', cycles = c(52, 26))
sf

## visualize alerts
output <- sf$output
plot(output$date, output$case, type = "l")
points(output$date[output$warning == 1],
       output$case[output$warning == 1], col = "red")

}
\references{
Wang X, Wu S, MacIntyre CR, et al. Using an adjusted Serfling regression model to improve the early warning at the arrival of peak timing of influenza in Beijing. PLoS One, 2015,10(3):e0119923.
}
