% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_peak_3d.R
\name{plot_peak_3d}
\alias{plot_peak_3d}
\title{Plot of the 3D data points with peaks highlighted in green}
\usage{
plot_peak_3d(dat, peaks, x.range = NA, y.range = NA, tol = 1e-05)
}
\arguments{
\item{dat}{A numeric matrix or data frame with at least three columns representing x, y, and z coordinates of data points.}

\item{peaks}{A numeric matrix or data frame with at least two columns representing the x and y coordinates of peak candidates.}

\item{x.range}{A numeric vector of length 2 specifying the x-axis range to include.}

\item{y.range}{A numeric vector of length 2 specifying the y-axis range to include.}

\item{tol}{A numeric value specifying the tolerance threshold: only peaks within this Euclidean distance from a data point are retained.}
}
\description{
This function creates an interactive 3D scatter plot of data points and highlights the peaks
that are within a specified tolerance distance from any data point.
}
\examples{
data(r)
k <- kdeC(r$dat, H = c(0.014, 0.014), gridsize = c(330, 330), cutNum = c(1, 1), w = r$z)
m <- findPeak(k, filter = 0, select = 100)
dat <- cbind(r$dat, r$z)
plot_peak_3d(dat, m)
}
