% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_peak_2d.R
\name{plot_peak_2d}
\alias{plot_peak_2d}
\title{Plot of the 2D data points with peaks highlighted in green}
\usage{
plot_peak_2d(dat, peaks, x.range = NA, y.range = NA)
}
\arguments{
\item{dat}{Data points used for kernel density estimation.}

\item{peaks}{A matrix of detected peaks with x- and y-coordinates.}

\item{x.range}{(optional) A numeric 2D vector specifying the x-axis range for filtering.}

\item{y.range}{(optional) A numeric 2D vector specifying the y-axis range for filtering.}
}
\value{
A scatter plot of the data points with the detected peaks highlighted in green.
}
\description{
Plot of the 2D data points with peaks highlighted in green
}
\examples{
data(r)
k <- kdeC(r$dat, H = c(0.014, 0.014), gridsize = c(330, 330), cutNum = c(1, 1), w = r$z)
m <- findPeak(k, filter = 0, select = 100)
plot_peak_2d(r$dat, m)
}
