% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kdeC.R
\name{kdeC}
\alias{kdeC}
\title{Two-dimensional fast weighted kernel density estimation}
\usage{
kdeC(x, H, gridsize, cutNum, w)
}
\arguments{
\item{x}{Data points in the format of an n x 2 matrix.}

\item{H}{Bandwidth, a vector containing 2 numeric values.}

\item{gridsize}{Number of points for each direction, a vector containing 2 integer values.}

\item{cutNum}{Number of pieces to be cut for each direction, a vector containing 2 integer values.}

\item{w}{Weight, a vector corresponding to parameter 'x'.}
}
\value{
A list containing three elements:
  \item{estimate}{The estimated values of the kernel density.}
  \item{evalpointsX}{The evaluation points along the X direction.}
  \item{evalpointsY}{The evaluation points along the Y direction.}
}
\description{
Two-dimensional fast weighted kernel density estimation
}
\examples{
data(r)
k <- kdeC(r$dat, H = c(0.014, 0.014), gridsize = c(330, 330), cutNum = c(1, 1), w = r$z)
}
