% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WIPF1.R
\name{WIPF1}
\alias{WIPF1}
\title{Weighted Iterative Proportional Fitting (WIPF) in one dimension}
\usage{
WIPF1(
  seed,
  weights,
  margin = 1,
  normalize = TRUE,
  tol = 10^-6,
  maxit = 1000,
  full = FALSE,
  ...
)
}
\arguments{
\item{seed}{A vector of non-negative values with the initial values.}

\item{weights}{A vector of non-negative values with the weights associated to each component of \code{seed}and with the same length as \code{seed}.}

\item{margin}{A non-negative scalar with the (weighted) marginal total to be fitted. Default, \code{1}.}

\item{normalize}{\code{TRUE}/\code{FALSE} argument indicating if weights should be normalized
to sum 1 before building the weighted sum to be compared with the margin value.
Default, \code{TRUE}. Normalization is necessary when we want to adjust a set of indexes
for which the margin correspond to other index that is a theoretical convex
combination of the inner indexes. This characterizes a typical context where WIPF could be of value.}

\item{tol}{Stopping criterion. The algorithm stops when the maximum absolute difference between
the solutions obtained in two consecutive iteration is lower than the value specified by \code{tol}.
Default, \code{0.000001}.}

\item{maxit}{Stopping criterion. A positive integer number indicating the maximum number of iterations
allowed. Default, \code{1000}. The algorithm will stop if the values to be fitted still has not
converged after this many iterations.}

\item{full}{\code{TRUE}/\code{FALSE} argument indicating if either only the solution should be shown or
a more complete output.}

\item{...}{Other arguments to be passed to the function. Not currently used.}
}
\value{
When \code{full = FALSE} an object similar to \code{seed} with the solution reached when the algorithm stops.
When \code{full = TRUE} a list with the following components:
\item{sol}{ An object similar to \code{seed} with the solution reached at convergence (or when the maximum number of iterations is reached).}
\item{iter}{ Number of iterations when the algorithm stops.}
\item{error.margins}{ An object similar to \code{margin} with the absolute differences between the values in \code{margin} and
the weighted sum(s) of the values in \code{sol}.}
\item{inputs}{ A list containing all the objects with the values used as arguments by the function.}
}
\description{
Implements WIPF in one dimension. This function updates, using a set of weights,
an initial 1-dimensional array, a vector (referred as the seed), to match a given value
(referred as the margin), in such as way that the weighted sum of the updated values coincide with the margin.
}
\note{
Weighted Iterative proportional fitting is an extension of IPF.
WIPF produces the same solutions than IPF with all weights being ones
and when they are not normalized. IPF is also known as RAS in economics,
raking in survey research or matrix scaling in computer science.
}
\examples{
s <- c(1.0595723, 0.9754876, 0.8589494, 0.8589123)
w <- c(651301.9, 581185.1, 555610.8, 602595.6)
example <- WIPF1(seed = s, weights = w)

}
\author{
Jose M. Pavia, \email{pavia@uv.es}
}
