% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_edge_function.R
\name{get_edge}
\alias{get_edge}
\title{get_edge}
\usage{
get_edge(
  target_area,
  input,
  x,
  y,
  species = "binomial",
  ed = "ED",
  category = "category",
  res = 1
)
}
\arguments{
\item{target_area}{Either a sp or sf object to which to calculate the WEGE 
index.}

\item{input}{Species ranges, either from a shapefile or from a georeferenced 
species list with a column for species, two columns for coordinates and one 
for the IUCN category.}

\item{x}{name of the longitude column.}

\item{y}{name of the latitude column.}

\item{species}{name of the species column.}

\item{ed}{name of the evolutionary distinctiveness column.}

\item{category}{name of IUCN the category column. Terminology must be as 
follows: DD for Data Deficient, LC for Least Concern, NT for Near Threatened, 
EN, for Endangered, CR for Critically Endangered, EW for Extinct in the wild 

and EX for Extinct.}

\item{res}{grid-cell size to use to calculate the range of the species in 
case a georeferenced species list was provided.}
}
\value{
a value corresponding to the EDGE score of the provided target_area
}
\description{
A function to get the WEGE index value for a provided polygon.
}
\examples{
library(WEGE) 
library(sp)
library(sf)

species <- letters[1:26]
range_list <- list()
for (i in seq_along(species)) {
  temp0 <- cbind(runif(3,1,50),runif(3,1,50))
  temp <- Polygon(rbind(temp0,temp0[1,]))
  range_list[[i]] <- Polygons(list(temp), ID = c(species[i]))
}
input <- st_as_sf(SpatialPolygons(range_list))
categories <- c('LC','NT','VU','EN','CR')
input$binomial <- species
input$category <- sample(size = nrow(input),x = categories,replace = TRUE)
input$ED <- runif(nrow(input),1,30)
temp0 <- cbind(runif(3,1,50),runif(3,1,50))
target_area <- Polygon(rbind(temp0,temp0[1,]))
target_area <- Polygons(list(target_area), ID = 'Target area')
target_area <- st_as_sf(SpatialPolygons(list(target_area)))

get_edge(target_area = target_area,input = input,species = 'binomial',category = 'category')

}
