% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wAnova_gh.R
\name{games_howell.test}
\alias{games_howell.test}
\title{games_howell.test}
\usage{
games_howell.test(levels, n, means, sd, conf.level = 0.95)
}
\arguments{
\item{levels}{A vector containing the level names of the independent variable.}

\item{n}{A vector containing the sample sizes for each level.}

\item{means}{A vector containing the sample means for each level.}

\item{sd}{A vector containing the sample standard deviations for each level.}

\item{conf.level}{The confidence level for the interval. Defaults to 0.95.}
}
\value{
A data frame of class "wAnova_gh" containing the pairwise comparisons with mean differences,
standard errors, confidence intervals, t-values, degrees of freedom, and p-values.
Significance codes are also included.
}
\description{
Games-Howell post hoc test for multiple comparisons after Welch's ANOVA.
}
\examples{
\donttest{
probe_data <- data.frame(
  group = c("probe_a", "probe_b", "probe_c"),
  size = c(10, 9, 8),
  mean = c(43.00000, 33.44444, 35.75000),
  sd = c(4.027682, 9.302031, 16.298554)
)
result <- games_howell.test(probe_data$group, probe_data$size, probe_data$mean, probe_data$sd)
print(result)
}

}
