% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmax.R
\name{fmax_test}
\alias{fmax_test}
\title{fmax.test}
\usage{
fmax_test(levels, n, sd)
}
\arguments{
\item{levels}{a vector of group labels or identifiers.}

\item{n}{A numeric vector of sample sizes for each group.}

\item{sd}{A numeric vector of standard deviations for each group.}
}
\value{
A list with the following components:
\describe{
  \item{fmax}{The ratio of the maximum to minimum variance.}
  \item{df}{Degrees of freedom associated with the test.}
  \item{k}{Number of groups.}
  \item{pval}{The p-value of the test.}
}


The levels parameter is used determine the number of groups. The variances are computed as the squares of sd.
Note: Applicable results assume normally distributed data with equal sample sizes

Null Hypothesis: Assumes homogeneity of variances, which means all groups have the same variance.
Alternative Hypothesis: Assumes that not all group variances are equal. This hypothesis is
supported if the p-value is below the significance level.
}
\description{
Performs Hartley's Fmax test for homogeneity of variances. This test assesses whether
the variances of multiple groups are equal, given that the sample sizes are the same.
It calculates the ratio of the maximum to the minimum variance and compares it to a
critical value from the Fmax distribution to determine if there is significant
deviation from homogeneity.
}
\examples{
\donttest{
probe_data <- data.frame(
  group = c("probe_a", "probe_b", "probe_c"),
  size = c(10, 10, 10),  # Equal sample sizes
  mean = c(43.00000, 33.44444, 35.75000),
  sd = c(4.027682, 9.302031, 16.298554)
)

# Perform Hartley's Fmax test
result <- fmax_test(
  levels = probe_data$group,
  n = probe_data$size,
  sd = probe_data$sd
)
}

}
