% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wals.R
\name{walsFit}
\alias{walsFit}
\title{Fitter function for Weighted Average Least Squares estimation}
\usage{
walsFit(
  X1,
  X2,
  y,
  sigma = NULL,
  prior = weibull(),
  method = "original",
  svdTol = .Machine$double.eps,
  svdRtol = 1e-06,
  keepUn = FALSE,
  eigenSVD = TRUE,
  prescale = TRUE,
  postmult = FALSE,
  ...
)
}
\arguments{
\item{X1}{Design matrix for focus regressors. Usually includes a constant
(column full of 1s) and can be generated using \code{\link[stats]{model.matrix}}.}

\item{X2}{Design matrix for auxiliary regressors. Usually does not include
a constant column and can also be generated using \code{\link[stats]{model.matrix}}.}

\item{y}{Response as vector.}

\item{sigma}{if NULL (default), then the variance of the error term is estimated,
see p.136 of \insertCite{magnus2016wals;textual}{WALS}. If sigma is specified,
then the unrestricted estimator is divided by sigma before performing the
Bayesian posterior mean estimation.}

\item{prior}{Object of class \code{"\link[WALS]{familyPrior}"}. For example
\code{\link[WALS]{weibull}} or \code{\link[WALS]{laplace}}.}

\item{method}{Specifies method used. Available methods are
\code{"original"} (default) or \code{"svd"}.}

\item{svdTol}{Tolerance for rank of matrix \eqn{\bar{Z}_{1}}
Only used if \code{method = "svd"}.
Checks if smallest eigenvalue in SVD of \eqn{\bar{Z}_1} and \eqn{\bar{Z}}
is larger than \code{svdTol}, otherwise reports a rank deficiency.}

\item{svdRtol}{Relative tolerance for rank of matrix \eqn{\bar{Z}_{1}}.
Only used if \code{method = "svd"}. Checks if ratio of largest to smallest
eigenvalue in SVD of \eqn{\bar{Z}_1} is larger than  \code{svdRtol},
otherwise reports a rank deficiency.}

\item{keepUn}{If \code{TRUE}, keeps the estimators of the unrestricted model,
i.e. \eqn{\tilde{\gamma}_{u}}.}

\item{eigenSVD}{If \code{TRUE}, then \code{\link[WALS]{semiorthogonalize}}
uses \code{\link[base]{svd}} to compute the eigendecomposition of
\eqn{\bar{\Xi}} instead of \code{\link[base]{eigen}}. In this case, the
tolerances of \code{svdTol} and \code{svdRtol} are used to
determine whether \eqn{\bar{\Xi}} is of full rank (need it for \eqn{\bar{\Xi}^{-1/2}}).}

\item{prescale}{If \code{TRUE} (default), prescales the regressors X1 and X2 with
\eqn{\Delta_1} and \eqn{\Delta_2}, respectively, to improve numerical stability
and make the coefficients of the auxiliary regressors scale equivariant.
See \insertCite{deluca2011stata;textual}{WALS} for more details.
\strong{WARNING: It is not recommended to set \code{prescale = FALSE}.}
The option \code{prescale = FALSE} only exists for historical reasons.}

\item{postmult}{If \code{TRUE}, then it computes
\deqn{Z_{2} = X_{2} \Delta_{2} T \Lambda^{-1/2} T^{\top},}
where \eqn{T} contains the eigenvectors and \eqn{\Lambda} the eigenvalues
from the eigenvalue decomposition
\deqn{\Xi = \Delta_2 X_{2}^{\top} M_{1} X_{2} \Delta_2 = T \Lambda T^{\top},}
instead of
\deqn{Z_{2} = X_{2} \Delta_{2} T \Lambda^{-1/2}.}
See \insertCite{huynhwals;textual}{WALS} for more details. The latter is used
in the original MATLAB code for WALS in the linear regression model
\insertCite{magnus2010growth,deluca2011stata,kumar2013normallocation,magnus2016wals}{WALS},
see eq. (12) of \insertCite{magnus2016wals;textual}{WALS}.
The first form is required in eq. (9) of \insertCite{deluca2018glm;textual}{WALS}.
It is not recommended to set \code{postmult = FALSE} when using \code{\link[WALS]{walsGLM}}
and \code{\link[WALS]{walsNB}}.}

\item{...}{Arguments for internal function \code{\link[WALS]{computePosterior}}.}
}
\value{
A list containing
\item{coef}{Model averaged estimates of all coefficients.}
\item{beta1}{Model averaged estimates of the coefficients of the focus regressors.}
\item{beta2}{Model averaged estimates of the coefficients of the auxiliary regressors.}
\item{gamma1}{Model averaged estimates of the coefficients of the transformed
focus regressors.}
\item{gamma2}{Model averaged estimates of the coefficients of the transformed
auxiliary regressors.}
\item{vcovBeta}{Estimated covariance matrix of the regression coefficients.}
\item{vcovGamma}{Estimated covariance matrix of the coefficients of the
transformed regressors.}
\item{sigma}{Estimated or prespecified standard deviation of the error term.}
\item{prior}{\code{familyPrior}. The \code{prior} specified in the arguments.}
\item{method}{Stores \code{method} used from the arguments.}
\item{betaUn1}{If \code{keepUn = TRUE}, contains the unrestricted
estimators of the coefficients of the focus regressors.}
\item{betaUn2}{If \code{keepUn = TRUE}, contains the unrestricted
estimators of the coefficients of the auxiliary regressors.}
\item{gammaUn1}{If \code{keepUn = TRUE}, contains the unrestricted
estimators of the coefficients of the transformed focus regressors.}
\item{gammaUn2}{If \code{keepUn = TRUE}, contains the unrestricted
estimators of the coefficients of the transformed auxiliary regressors.}
\item{fitted.values}{Estimated conditional means of the data.}
\item{residuals}{Residuals, i.e. response - fitted mean.}
\item{X1names}{Names of the focus regressors.}
\item{X2names}{Names of the auxiliary regressors.}
\item{k1}{Number of focus regressors.}
\item{k2}{Number of auxiliary regressors.}
\item{n}{Number of observations.}
\item{condition}{Condition number of the matrix
\eqn{\Xi = \Delta_{2} X_{2}^{\top} M_{1} X_{2} \Delta_{2}}.}
}
\description{
Workhorse function behind \code{\link[WALS]{wals}} and \code{\link[WALS]{walsGLM}}.
}
\examples{
X <- model.matrix(gdpgrowth ~ lgdp60 + equipinv + school60 + life60 + popgrowth
                  + law + tropics + avelf + confucian, data = GrowthMPP)
X1 <- X[, c("(Intercept)", "lgdp60", "equipinv", "school60", "life60", "popgrowth")]
X2 <- X[, c("law", "tropics", "avelf", "confucian")]
y <- GrowthMPP$gdpgrowth

walsFit(X1, X2, y, prior = weibull(), method = "svd")

}
\references{
\insertAllCited{}
}
\seealso{
\link{wals}, \link{walsGLM}.
}
