% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WACSvalid.R
\name{WACSvalid}
\alias{WACSvalid}
\title{Performs validations of WACS simulations}
\usage{
WACSvalid(
  what = "Sim",
  wacsdata = NULL,
  wacspar = NULL,
  wacssimul = NULL,
  varname = NULL,
  varname2 = NULL,
  base = 0,
  above = TRUE,
  months = 1:12
)
}
\arguments{
\item{what}{Type of validation. Possible choices are:
\tabular{ll}{
\env{="Sim"} \tab Compares a simulation run to data \cr
\env{="Rain"}\tab qq-plots of rainfall, per season \cr
\env{="MeanSd"}\tab Compares monthly mean and standard deviations \cr
\env{="BiVar"}\tab Compares monthly variate correlations \cr
\env{="CorTemp"}\tab Compares monthly temporal correlations \cr
\env{="SumBase"}\tab Compares sums above a threshold \cr
\env{="Persistence"}\tab Compares persistence of a variable above (or below) a threshold \cr
}}

\item{wacsdata}{WACS data obtained when calling \link{WACSdata}}

\item{wacspar}{WACS parameters estimated when calling \link{WACSestim}}

\item{wacssimul}{WACS simulation obtained when calling \link{WACSsimul}}

\item{varname}{Variable on which the validation is performed}

\item{varname2}{Second variable on which validation is performed (only needed if \code{what=BiVar})}

\item{base}{Threshold used for "SumBase" and "Persistence"}

\item{above}{Boolean value used for "Persistence": 
TRUE if data is considered above threshold; 
FALSE otherwise}

\item{months}{Months to which the analysis should be restricted (only for "SumBase" and "Persistence")}
}
\value{
A list containing all information needed for plots; contains also the type of validation, as a class
}
\description{
The validation is based on different types of 
statistics computed on  WACS data, WACS parameters and WACS simulations.
}
\note{
If \code{what=sim}, data and simulations are displayed as a function of the day of the year, from 1 to 365. 
Smoothed versions of daily average and daily envelopes (defined by average +/- 2. standard deviations) are also displayed. 


If \code{what=rain}, qq-plots and superimposition of histograms and models of rain are produced for each season.


If \code{what=MeanSd}, boxplots of monthly means and monthly standard deviations are compared. 
The median value of the monthly mean, resp. monthly standard deviation, of the data are displayed 
on top of the boxplots computed on the simulations.


#' If \code{what=BiVar}, boxplots of monthly correlations coefficients between \code{varname} and \code{varname2}
are compared. The median value of the correlation coefficient computed on the data is displayed 
on top of the boxplots computed on the simulations.


If \code{what=CorTemp}, boxplots of monthly 1-day auto correlation are compared. The median value of the 
auto-correlation coefficient computed on the data is displayed 
on top of the boxplots computed on the simulations.


If \code{what=SumBase}, boxplots of the sum of the variable \code{varname} above a given threshold, \code{base},
is computed during the months provided in the variable \code{months}.


If \code{what=Persistence}, histograms of consecutive days of the variable \code{varname} above (or below) a given
threshold,  \code{base}, are compared. If \code{above=TRUE}, consecutive days above the threshold are computed, 
whereas days below the threshold are computed if \code{above=FALSE}. Months can be selected 
with the variable \code{months}.
}
\examples{
\dontrun{
  ## Simple example
  data(ClimateSeries)
  ThisData = WACSdata(ClimateSeries)
  ThisPar  = WACSestim(ThisData)
  ThisSim  = WACSsimul(ThisPar, from="1995-01-01", to="2012-12-31")
  Val1 = WACSvalid(what="Sim",wacsdata = ThisData, 
                   wacspar = ThisPar, wacssimul = ThisSim, varname="tmin")
  Val2 = WACSvalid(what="MeanSd",wacsdata = ThisData, 
                   wacssimul = ThisSim, varname="RG")
  Val3 = WACSvalid(what="SumBase", wacsdata = ThisData,  
                   wacssimul = ThisSim, varname="tmoy", base=5, month=2:5)
  Val4 = WACSvalid(what="Persistence",wacsdata = ThisData,  
                   wacssimul = ThisSim, varname="tmin", base=0, above=FALSE)
}
}
