% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WACSsimul.R
\name{WACSsimul}
\alias{WACSsimul}
\title{Performs simulations based on estimated parameters of the WACS model}
\usage{
WACSsimul(wacspar, from, to, first.day = NULL, REJECT = FALSE)
}
\arguments{
\item{wacspar}{Parameters of the WACS model estimated with WACSestim}

\item{from}{Starting date of the simulation (format: "yyyy-mm-dd")}

\item{to}{Ending date of the simulation (format: "yyyy-mm-dd")}

\item{first.day}{Conditioning values for first day (optional)}

\item{REJECT}{Boolean indicating whether a rejection technique is used to guarantee variables within bounds.
Default is FALSE. In this case, values outside bounds are forced to the bounds.}
}
\value{
A list containing the simulation results
}
\description{
Performs simulations based on estimated parameters of the WACS model
}
\note{
Variables are simulated sequentially: day d is simulated conditionally on the values at day (d-1).
If \code{REJECT=TRUE}, a rejection technique is used to force simulated variables within the bounds. 
If \code{REJECT=FALSE}, variables that could have been simulated outside the bounds are forced to the limits.
The rejection technique tends to produce biases. \code{REJECT=FALSE} is thus recommended
}
\examples{
\dontrun{
  ## Simple example
  data(ClimateSeries)
  ThisData = WACSdata(ClimateSeries)
  ThisPar  = WACSestim(ThisData)
  ThisSim  = WACSsimul(ThisPar, from="1995-01-01", to="2012-12-31")
}
}
