% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random.R
\name{24. Random generators}
\alias{24. Random generators}
\alias{rvlidigits}
\alias{rvliunif}
\alias{rvliunif.default}
\alias{rvliunif.numeric}
\alias{rvliunif.vli}
\alias{rvlibin}
\alias{rvlibin.default}
\alias{rvlibin.numeric}
\alias{rvlibin.vli}
\alias{rvlinegbin}
\alias{rvlinegbin.default}
\alias{rvlinegbin.numeric}
\alias{rvlinegbin.vli}
\alias{rvliprime}
\alias{rvliprime.default}
\alias{rvliprime.numeric}
\alias{rvliprime.vli}
\title{Random Generators of vli Objects}
\usage{
rvlidigits(d)

rvliunif(x, y)

\method{rvliunif}{default}(x, y)

\method{rvliunif}{numeric}(x, y)

\method{rvliunif}{vli}(x, y)

rvlibin(n, p)

\method{rvlibin}{default}(n, p)

\method{rvlibin}{numeric}(n, p)

\method{rvlibin}{vli}(n, p)

rvlinegbin(s, p)

\method{rvlinegbin}{default}(s, p)

\method{rvlinegbin}{numeric}(s, p)

\method{rvlinegbin}{vli}(s, p)

rvliprime(y, iter = 10, test = "MR")

\method{rvliprime}{default}(y, iter = 10, test = "MR")

\method{rvliprime}{numeric}(y, iter = 10, test = "MR")

\method{rvliprime}{vli}(y, iter = 10, test = "MR")
}
\arguments{
\item{d}{number of digits of the vli class object being generated; numeric}

\item{x}{lower bound for the object of class vli being generated; object of class vli or 32 bits integer}

\item{y}{upper bound for the object of class vli being generated; object of class vli or 32 bits integer}

\item{n}{number of independent Bernoulli trials; object of class vli 32 bits integer}

\item{p}{probability of success; numeric}

\item{s}{number of successes; vli class object or 32 bits integer}

\item{iter}{number of iterations for each number to be tested; numeric}

\item{test}{chosen primality test: "F" for the Fermat Test, "SS" for the Solovay-Strassen Test or "MR" (by default) for the Miller-Rabin Test; character}
}
\value{
objects of class vli in all cases:

\code{rvlidigits(d)} returns a object of class vli belonging to the interval \code{[0, 10^d)}

\code{rvliunif(x, y)} returns a object of class vli belonging to the interval \code{[x, y)}

\code{rvlibin(n, p)} returns a object of class vli belonging to the interval \code{[0, n]}

\code{rvlinegbin(x, y)} returns a object of class vli belonging to the interval \code{[n, Inf)}

\code{rvliprime(y, iter, test)} returns a object of class vli with the value of a prime number belonging to the interval \code{[2, y)}
}
\description{
Random generators of vli (Very Large Integer) objects following different probability distributions.
}
\details{
The function \code{rvlidigits(d)} returns a vli object of \code{d} digits randomly generated following the uniform distribution. It is the most efficient way of generating random vli objects.

The function \code{rvliunif(x, y)} returns a vli object randomly generated following the Uniform distribution with parameters \code{x} and \code{y}.

The function \code{rvlibin(n, p)} returns a vli object randomly generated following the Binomial distribution with parameters \code{n} and \code{p}, where \code{n} is the number of Bernoulli trials and \code{p} the probability of success.

The function \code{rvlinegbin(x, y)} returns a vli object randomly generated following the Negative Binomial distribution with parameters \code{s} and \code{p}, where \code{s} is the number of successes and \code{p} the probability of success.

The function \code{rvliprime(y, iter, test)} returns a vli object randomly chosen from the set of primes up to \code{y}.
}
\examples{
rvlidigits(2000)
rvliunif(3425, as.vli("2061341345304562604342"))
rvlibin(100, 0.6)
rvlinegbin(as.vli("1000000"), 0.5)
rvliprime(as.vli("100000"), iter = 10, test = "MR")
}
\author{
Javier Leiva Cuadrado
}
