% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semiVarReg_multi.R
\name{semiVarReg.multi}
\alias{semiVarReg.multi}
\title{Semi parametric mean and variance regression (multivariate)}
\usage{
semiVarReg.multi(
  y,
  x,
  mean.model = c("zero", "constant", "linear", "semi"),
  mean.vars = c(1),
  knots.m = NULL,
  var.model = c("constant", "linear", "semi"),
  var.vars = c(1),
  knots.v = NULL,
  degree = 2,
  control = list(...),
  ...
)
}
\arguments{
\item{y}{Vector containing outcome data. Must be no missing data and any censored values must
be set to the limits of detection.}

\item{x}{Matrix containing the covariate data. Must be no missing data and same length as \code{y}.}

\item{mean.model}{Vector to specify the mean model to be fit to the data. The possible inputs are
\code{"zero"}, \code{"constant"}, or a vector to indicate if covariates are to be \code{"linear"} or \code{"semi"}. \code{"semi"}
indicates a semi-parametric spline model, with the number of internal knots specified in
\code{knots.m}. If covariates are fit, each covariate needs an indicator of \code{"linear"} or \code{"semi"}, where \code{mean.vars} specifies each covariate.}

\item{mean.vars}{Vector to specify column(s) in \code{x} referring to covariates to be fit in the mean model,
eg c(1,2) indicates columns 1 and 2 in \code{x}. Must be the same length as \code{mean.model} which specifies
if they are fit as linear/semi. If semi, use \code{knots.m} to specify knots.}

\item{knots.m}{Vector indicating the number of internal knots to be fit in each of covariate(s) fit in the semi-parametric
mean model. Must be one entry per \code{"semi"} covariate in \code{mean.model}. Knots are placed equidistantly over each covariate.}

\item{var.model}{Vector to specify the variance model to be fit to the data. The possible inputs are
\code{"constant"}, or a vector to indicate if each covariate is to be \code{"linear"} or \code{"semi"}. \code{"semi"} indicates a semi-parametric
B-spline model, with the number of internal knots specified in \code{knots.v}.}

\item{var.vars}{Vector to specify column(s) in \code{x} referring to covariates to be fit in the variance model,
eg c(1,2) indicates columns 1 and 2 in \code{x}. Must be the same length as \code{var.model} which specifies
if they are fit as linear/semi. If semi, use \code{knots.v} to specify knots.}

\item{knots.v}{Vector indicating the number of internal knots to be fit in the semi-parametric
variance model. Knots are placed equidistantly over the covariate.}

\item{degree}{Integer indicating the degree of the splines fit in the mean and the variance models.
The default value is \code{2}.}

\item{control}{list of control parameters. See \code{\link{VarReg.control}}.}

\item{...}{arguments to be used to form the default control argument if it is not supplied
directly}
}
\value{
\code{semiVarReg.multi} returns an object of class \code{"VarReg"} which inherits some components from the class \code{"glm"}. This object of class \code{"VarReg"} is a list containing the following components:
\itemize{
 \item\code{modeltype}: Text indicating the model that was fit, indicating an uncensored approach was performed.
 \item\code{knots.m}, \code{knots.v}, \code{degree}, \code{meanmodel}, \code{varmodel}: Returning the input variables as described above
 \item\code{converged}: Logical argument indicating if convergence occurred.
 \item\code{iterations}: Total iterations performed.
 \item\code{reldiff}: the positive convergence tolerance that occurred at the final iteration.
 \item\code{loglik}: Numeric variable of the maximised log-likelihood.
 \item\code{boundary}: Logical argument indicating if the MLE is on the boundary of the parameter space.
 \item\code{aic.c}: Akaike information criterion corrected for small samples
 \item\code{aic}: Akaike information criterion
 \item\code{bic}: Bayesian information criterion
 \item\code{hqc}: Hannan-Quinn information criterion
 \item\code{mean.ind}: Vector of integer(s) indicating the column number(s) in the dataframe
 \code{data} that were fit in the mean model.
 \item\code{mean}: Vector of the maximum likelihood estimates of the mean parameters.
 \item \code{var.ind}: Vector of integer(s) indicating the column(s) in the dataframe
 \code{data} that were fit in the variance model.
 \item\code{variance}: Vector of the maximum likelihood estimates of the variance parameters.
 \item\code{data}: Dataframe containing the variables included in the model.}
}
\description{
\code{semiVarReg.multi} performs semi-parametric mean and variance regression models. This is
designed for multiple covariates fit in the mean and variance models.
}
\examples{
data(mcycle)
## run a model with linear mean and linear variance:
linmodel<-semiVarReg.multi(mcycle$accel, x=mcycle, mean.model="linear",mean.vars=2,
var.model="linear", var.vars=2,  maxit=10000)
## run a model with semi-parametric mean (4 internal knots) and semi-parametric variance (2 knots):
##not run
##semimodel<-semiVarReg.multi(mcycle$accel, x=mcycle, meanmodel="semi",mean.vars=2, varmodel="semi",
##var.vars=2,knots.m=4, knots.v=2, maxit=10000)
}
