% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyl_tree_cluster_dbscan.R
\name{phyl_tree_cluster_dbscan}
\alias{phyl_tree_cluster_dbscan}
\title{Perform DBSCAN Clustering on a Phylogenetic Tree}
\usage{
phyl_tree_cluster_dbscan(input_obj, cutoff, nmin)
}
\arguments{
\item{input_obj}{A `AAStringSet` object containing protein sequences.}

\item{cutoff}{A numeric value specifying the distance cutoff for clustering.}

\item{nmin}{An integer specifying the minimum number of points required to form a cluster (DBSCAN parameter).}
}
\value{
This function returns a `AAStringSet` object containing protein sequences with outliers removed.
}
\description{
This function applies the DBSCAN clustering algorithm on a set of protein sequences
to identify clusters and remove outliers based on a distance cutoff.
}
\details{
The function uses the DBSCAN algorithm to cluster sequences based on their phylogenetic distances. 
Sequences identified as outliers are excluded from the final output.
}
\examples{
# Example usage:
library(Biostrings)

# Create an AAStringSet object with the sequences
seqs <- AAStringSet(c(
  seq1 = "MKTIIALSYIFCLVFADYKDDDDK",
  seq2 = "MKTIIALSYIFCLVFADYKDLLKDDDD",
  seq3 = "MKTIIALSYIFCLVFADEELYKDDDD",
  seq4 = "MKTIEIALSYIFCLVFADYKDDDD",
  seq5 = "MKTIIKLAAASYIFCLVFADYKDDDD",
  seq6 = "MKTIIALSKIPFCLVFADYKDDDD",
  seq7 = "MKTIIALSYIFiQEERTCLVFADYKDDDD"
))

# Perform DBSCAN clustering and remove outliers
no_outliers <- phyl_tree_cluster_dbscan(seqs, cutoff = 0.5, nmin = 5)
}
